// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Vehicle/Manager/hkpVehicleCastBatchingManager.h>
#include <Physics2012/Collide/Query/Multithreaded/CollisionQuery/hkpCollisionQueryJobs.h>

struct hkpShapeLinearCastCommand;

/// Manages a set of vehicles whose wheelCollide objects are instances of hkpVehicleLinearCastWheelCollide.
/// LinearCasts can be batched and performed multithreaded.
class HK_EXPORT_PHYSICS_2012 hkpVehicleLinearCastBatchingManager : public hkpVehicleCastBatchingManager
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VEHICLE );
        HK_DECLARE_REFLECTION();

            /// Constructor.
        hkpVehicleLinearCastBatchingManager() { }

        //
        // Interface for asynchronous multithreading.
        //

        virtual int getBufferSize( int numJobs, hkArray< hkpVehicleInstance* >& activeVehicles );

        virtual int buildAndAddCastJobs( const hkpWorld* world, hkInt32 filterSize, int numJobs, hkJobQueue* jobQueue, hkSemaphoreBusyWait* semaphore, void* buffer, hkArray< hkpVehicleInstance* >& activeVehicles );

        virtual void stepVehiclesUsingCastResults( const hkStepInfo& updatedStepInfo, int numJobs, void* buffer, hkArray< hkpVehicleInstance* >& activeVehicles );

    public:
        //
        // Internal
        //

            /// Returns the total number of commands which need to be issued for the vehicles.
        void getTotalNumCommands( hkArray< hkpVehicleInstance* >& activeVehicles, int& numCommands, int& numWheels ) const;

            /// The buffer is divided as follows:
        struct LinearCastBatch
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkpVehicleLinearCastBatchingManager::LinearCastBatch);
                /// A pointer to enough space for one collidable per wheel.
            hkpCollidable* m_collidableStorage;
                /// A pointer to space for pair linear cast commands.
                /// Must be big enough for the number of commands returned by getTotalNumCommands().
            hkpPairLinearCastCommand* m_commandStorage;
                /// A pointer to enough space for one hkpRootCdPoint per command.
                /// The elements of this array correspond directly to the commands in
                /// m_commandStorage, and are arranged in the same way.
            hkpRootCdPoint* m_outputStorage;
                /// The headers of the LinearCast jobs.
            hkpCollisionQueryJobHeader* m_jobHeaders;
        };

            /// Fills out a LinearCastBatch structure with pointers into the provided buffer.
            /// \param numJobs the number of jobs which are intended to be built.
        void getLinearCastBatchFromBuffer( void* buffer, int numJobs, LinearCastBatch& batchOut, hkArray< hkpVehicleInstance* >& activeVehicles );
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
