// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


#include <Physics2012/Vehicle/DriverInput/hkpVehicleDriverInput.h>
#include <Physics2012/Vehicle/Transmission/hkpVehicleTransmission.h>

class hkpVehicleInstance;


/// The hkpVehicleEngine is the component responsible for calculating values
/// related to the engine of the vehicle, in particular the engine torque and RPM. A
/// typical hkpVehicleEngine implementation would collaborate with the vehicle's
/// hkpVehicleDriverInput (for the accelerator pedal input) and its
/// hkpVehicleTransmission (for RPM and torque transmission).
class HK_EXPORT_PHYSICS_2012 hkpVehicleEngine : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VEHICLE);
        HK_DECLARE_REFLECTION();

        /// Container for data output by the engine calculations.
        /// Note that each of these members can be accessed through
        /// the hkpVehicleInstance.
        struct EngineOutput
        {
            public:
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VEHICLE, hkpVehicleEngine::EngineOutput );
            /// The torque currently supplied by the engine.
            hkReal m_torque;

            /// The RPM the engine is currently running at.
            hkReal m_rpm;
        };

        //
        // Methods
        //

            /// Sets the current values of the torque and rpm.
        virtual void calcEngineInfo(const hkReal deltaTime, const hkpVehicleInstance* vehicle, const hkpVehicleDriverInput::FilteredDriverInputOutput& FilteredDriverInputOutput, const hkpVehicleTransmission::TransmissionOutput& TransmissionOutput, EngineOutput& engineOutput ) = 0;

    protected:

        hkpVehicleEngine() {}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
