// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Vehicle/Camera/hkp1dAngularFollowCamCinfo.h>


/// The hkp1dAngularFollowCam attaches a camera to a vehicle to aid rendering.
/// The position of the camera rotates around the object using a single axle
/// (normally the up axis).
/// The camera tries to slowly move to a certain point (m_positionUS) defined in object space
/// and always looks at a given point in object space.
/// See hkp1dAngularFollowCamCinfo for parameter description
class HK_EXPORT_PHYSICS_2012 hkp1dAngularFollowCam : public  hkReferencedObject
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_CAMERA);
            /// Default constructor
        hkp1dAngularFollowCam ();

            /// Constructor.
        hkp1dAngularFollowCam (const hkp1dAngularFollowCamCinfo &bp);

            /// Destructor.
        virtual ~hkp1dAngularFollowCam();

            /// Reset all values except pointer values.
        void reinitialize( const hkp1dAngularFollowCamCinfo &bp );

        struct CameraInput
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_CAMERA, hkp1dAngularFollowCam::CameraInput);
            hkVector4       m_linearVelocity;
            hkVector4       m_angularVelocity;
            hkTransform     m_fromTrans;
            hkSimdReal      m_deltaTime;
        };

        // Output of the camera calculations
        struct CameraOutput
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_CAMERA, hkp1dAngularFollowCam::CameraOutput);
            hkVector4  m_positionWS;
            hkVector4  m_lookAtWS;
            hkVector4  m_upDirWS;
            hkSimdReal m_fov;
        };

            /// Immediately jump to the ideal yaw angle.
        virtual void resetCamera( const hkTransform& trans, hkVector4Parameter linearVelocity, hkVector4Parameter angularVelocity);

        virtual void calculateCamera ( const CameraInput &in, CameraOutput &out );

    protected:


        hkSimdReal m_cameraYawAngle;

        hkSimdReal m_yawCorrection;
        hkSimdReal m_yawSignCorrection;

        hkSimdReal m_velocityRange; // derived from the sets

        hkVector4 m_upDirWS;
        hkVector4 m_rigidBodyForwardDir;

        hkVector4 m_flat0DirWS;  // an orthogonal to m_upDirWS
        hkVector4 m_flat1DirWS;  // an orthogonal to m_upDirWS and m_flat0DirWS

        hkp1dAngularFollowCamCinfo::CameraSet m_set[2];

    protected:
            /// Internal methods for calculating camera position
        void calcYawAngle(hkSimdRealParameter factor, const hkTransform& trans, hkVector4Parameter linearVelocity, hkSimdReal& yaw_angle);
        void calcVelocityFactor(hkVector4Parameter bodyVelocity, hkSimdReal& factor);
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
