// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Vehicle/DriverInput/hkpVehicleDriverInput.h>

class hkpVehicleInstance;

/// This component manages the state of torques applied by the vehicle brakes, and
/// the blocking of wheels e.g., due to handbraking or strong braking being
/// applied.
class HK_EXPORT_PHYSICS_2012 hkpVehicleBrake : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VEHICLE);
        HK_DECLARE_REFLECTION();

            /// Container for data output by the brake calculations.
        struct WheelBreakingOutput
        {
            public:
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VEHICLE, hkpVehicleBrake::WheelBreakingOutput );

                /// The breaking torque of the wheel.
            hkInplaceArray< hkReal, 32 > m_brakingTorque;

                /// Indicates whether or not a wheel is locked.
            hkInplaceArray< hkBool, 32 > m_isFixed;

                /// Time since the torque applied was maximum. In order to implement wheel
                /// blockage warning this is a float right now, a time struct would be better
                /// because over time the accuracy will get less and less.
            hkReal m_wheelsTimeSinceMaxPedalInput;
        };

        //
        // Methods
        //

            /// Calculates information about the effects of braking on the vehicle.
        virtual void calcBreakingInfo(const hkReal deltaTime, const hkpVehicleInstance* vehicle, const hkpVehicleDriverInput::FilteredDriverInputOutput& FilteredDriverInputOutput, WheelBreakingOutput& breakingInfo) = 0;

    protected:

        hkpVehicleBrake() {}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
