// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


#include <Physics2012/Vehicle/Brake/hkpVehicleBrake.h>

/// The class hkpVehicleDefaultBrake implements a braking system that is independent at
/// every wheel. For each wheel there is a maximum torque the brakes can apply,
/// which is scaled by the input from the brake pedal. In addition, wheels can
/// automatically block if the driver presses the brake pedal strongly enough for
/// a certain amount of time. Finally, if the driver is using the handbrake,
/// wheels connected to it will block.
class HK_EXPORT_PHYSICS_2012 hkpVehicleDefaultBrake : public hkpVehicleBrake
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

            /// Default constructor
        hkpVehicleDefaultBrake();

        //
        // Methods
        //

            /// Calculates information about the effects of braking on the vehicle.
        virtual void calcBreakingInfo(const hkReal deltaTime, const hkpVehicleInstance* vehicle, const hkpVehicleDriverInput::FilteredDriverInputOutput& FilteredDriverInputOutput, WheelBreakingOutput& breakingInfo);

        //
        // Members
        //
    public:

            ///
        struct WheelBrakingProperties
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VEHICLE, hkpVehicleDefaultBrake::WheelBrakingProperties );
            HK_DECLARE_REFLECTION();

            /// The maximum torque the wheel can apply when braking. Increasing m_wheelsMass and
            /// m_wheelsMaxBrakingTorque for each wheel allows the vehicle to brake harder.
            hkReal m_maxBreakingTorque;

            /// The minimum amount of braking from the driver that could cause the wheel to
            /// block (range [0..1])
            hkReal m_minPedalInputToBlock;

            /// True if the particular wheel is connected to handbrake (locks when handbrake is
            /// on).
            hkBool m_isConnectedToHandbrake;
        };

            /// Array of braking properties for each of the wheels.
        hkArray<struct WheelBrakingProperties> m_wheelBrakingProperties;

            /// The time (in secs) after which, if the user applies enough brake input, the
            /// wheel will block.
        hkReal m_wheelsMinTimeToBlock;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
