// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class hkpVehicleInstance;

/// The hkpVehicleAerodynamics is responsible for providing the total force and
/// torque applied to the chassis by environmental forces. Examples of
/// environmental forces include aerodynamic drag and aerodynamic lift.
class HK_EXPORT_PHYSICS_2012 hkpVehicleAerodynamics : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VEHICLE);
        HK_DECLARE_REFLECTION();

            /// Container for data output by the aerodynamics calculations.
        struct AerodynamicsDragOutput
        {
            public:
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VEHICLE, hkpVehicleAerodynamics::AerodynamicsDragOutput );
                /// The total force applied by all aerodynamics forces.
            hkVector4 m_aerodynamicsForce;

                /// The total torque applied by all aerodynamics forces
            hkVector4 m_aerodynamicsTorque;
        };

        //
        // Methods
        //

            /// Calculates the effect of aerodynamic forces on the vehicle.
        virtual void calcAerodynamics(const hkReal deltaTime, const hkpVehicleInstance* vehicle, AerodynamicsDragOutput& dragInfoOut) = 0;

    protected:

        hkpVehicleAerodynamics() {}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
