// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Vehicle/AeroDynamics/hkpVehicleAerodynamics.h>

/// The hkpVehicleDefaultAerodynamics class implements an
/// aerodynamics component that accounts for the following: aerodynamic lift
/// (up/down force cause by pressure differences at high speeds),
/// aerodynamic drag (caused by air resistance) and extra gravity (non
/// physically-based force, but good for gameplay).
class HK_EXPORT_PHYSICS_2012 hkpVehicleDefaultAerodynamics : public hkpVehicleAerodynamics
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

            /// Default constructor
        hkpVehicleDefaultAerodynamics();

        //
        // Methods
        //

            /// Calculates the effect of aerodynamic forces on the vehicle.
        virtual void calcAerodynamics(const hkReal deltaTime, const hkpVehicleInstance* vehicle, AerodynamicsDragOutput& dragInfoOut);

            /// Calculates the drag force on the vehicle.
        virtual hkReal calcAerodynamicDrag(hkReal forwardVelocity) const;

            /// Calculates the lift force on the vehicle.
        virtual hkReal calcAerodynamicLift(hkReal forwardVelocity) const;

        //
        // Members
        //
    public:

            /// The density of the air that surrounds the vehicle, usually, 1.3 kg/m3.
        hkReal m_airDensity;

            /// The frontal area, in m2, of the car.
        hkReal m_frontalArea;

            /// The drag coefficient of the car.
        hkReal m_dragCoefficient;

            /// The lift coefficient of the car (it can be either positive or negative).
        hkReal m_liftCoefficient;

            /// An extra, fictional (non-physical) gravity force, to be applied to the body.
        hkVector4 m_extraGravityws;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
