// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Utilities/Weapons/hkpBallGun.h>



/// A ball gun that is fixed at a position in the world and shoots from there.
class HK_EXPORT_PHYSICS_2012 hkpMountedBallGun : public hkpBallGun
{
    public:

        HK_DECLARE_CLASS(hkpMountedBallGun, New, Reflect, BypassCtor);

        hkpMountedBallGun(int numBullets=100);

        void afterReflectNew()
        {
            m_type = WEAPON_TYPE_MOUNTEDBALLGUN;
        }

    public:

        virtual void fireGun(hkpWorld* world, const hkTransform& viewTransform);

    public:

            /// The gun will be 'positioned' at this location, i.e., its projectiles will be fired from here.
        hkVector4 m_position; //+default(0.0f,100.0f,0.0f) +hk.Semantics("POSITION") +hk.RangeReal(absmin=-10000.0,absmax=100000.0) +hk.Ui(visible=true, label="World Position")
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
