// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/Queue/hkQueue.h>
#include <Physics2012/Utilities/Weapons/hkpFirstPersonGun.h>



/// A simple ball gun that throws objects (physics shape = sphere) from the camera position into the world.
class HK_EXPORT_PHYSICS_2012 hkpBallGun : public hkpFirstPersonGun
{
    public:

        HK_DECLARE_CLASS(hkpBallGun, Reflect, New, BypassCtor);

        hkpBallGun( int numBullets=100 );
        void afterReflectNew()
        {
            m_type = WEAPON_TYPE_BALLGUN;
            m_addedBodies = new hkQueue<class hkpRigidBody*>;
            m_addedBodies->setCapacity(m_maxBulletsInWorld);
        }

        virtual ~hkpBallGun();

    public:

        virtual void fireGun( hkpWorld* world, const hkTransform& viewTransform );

        virtual void reset( hkpWorld* world );

    public:

        hkReal m_bulletRadius;                      //+default(0.2) +hk.Semantics("DISTANCE") +hk.RangeReal(absmin=0.0,absmax=100.0,softmin=0.0,softmax=1.0) +hk.Ui(visible=true, label="Radius", group="Bullet")

        hkReal m_bulletVelocity;                    //+default(40.0) +hk.RangeReal(absmin=0.0,absmax=10000.0,softmin=0.0,softmax=100.0) +hk.Ui(visible=true, label="Velocity")

        hkReal m_bulletMass;                        //+default(50.0) +hk.RangeReal(absmin=0.0,absmax=1000000.0,softmin=0.0,softmax=100.0) +hk.Ui(visible=true, label="Mass")

        hkReal m_damageMultiplier;                  //+default(50.0) +hk.RangeReal(absmin=0.0,absmax=10000.0,softmin=0.0,softmax=10.0) +hk.Ui(visible=true, endGroup=true)

        int m_maxBulletsInWorld;                    //+default(100) +hk.RangeInt32(absmin=0,absmax=100) +hk.Ui(visible=true)

        hkVector4 m_bulletOffsetFromCenter;         //+default(0.0f,0.0f,0.0f) +hk.Semantics("POSITION") +hk.RangeReal(absmin=-10000.0,absmax=100000.0) +hk.Ui(visible=true, label="Center Offset")

        hkQueue<class hkpRigidBody*>* m_addedBodies;//+nosave
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
