// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Physics2012/Collide/hkpExport.h>
#include <Physics2012/Dynamics/World/hkpWorld.h>
#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>
#include <Physics2012/Dynamics/World/hkpPhysicsSystem.h>
#include <Physics2012/Dynamics/World/Listener/hkpWorldDeletionListener.h>
#include <Physics/Constraint/Data/hkpConstraintData.h>

#include <Physics2012/Utilities/VisualDebugger/hkpPhysicsContext.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpBroadphaseViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpMidphaseViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpConstraintViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpActiveContactPointViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpInactiveContactPointViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpToiContactPointViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpToiCountViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpPhantomDisplayViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpRigidBodyCentreOfMassViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpRigidBodyLocalFrameViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpRigidBodyInertiaViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpShapeDisplayViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpConvexRadiusViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpSweptTransformDisplayViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpSimulationIslandViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Utilities/hkpMousePickingViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpWorldSnapshotViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Vehicle/hkpVehicleViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpWeldingViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpInconsistentWindingViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpSingleBodyConstraintViewer.h>

#include <Common/Visualize/hkVisualDebugger.h>

void HK_CALL hkpPhysicsContext::registerAllPhysicsProcesses()
{
    hkpBroadphaseViewer::registerViewer();
    hkpMidphaseViewer::registerViewer();
    hkpRigidBodyCentreOfMassViewer::registerViewer();
    hkpRigidBodyLocalFrameViewer::registerViewer();
    hkpConstraintViewer::registerViewer();
    hkpConvexRadiusViewer::registerViewer();
    hkpActiveContactPointViewer::registerViewer();
    hkpInactiveContactPointViewer::registerViewer();
    hkpToiContactPointViewer::registerViewer();
    hkpToiCountViewer::registerViewer();
    hkpRigidBodyInertiaViewer::registerViewer();
    hkpMousePickingViewer::registerViewer();
    hkpPhantomDisplayViewer::registerViewer();
    hkpShapeDisplayViewer::registerViewer();
    hkpSimulationIslandViewer::registerViewer();
    hkpSweptTransformDisplayViewer::registerViewer();
    hkpVehicleViewer::registerViewer();
    hkpWorldSnapshotViewer::registerViewer();
    hkpWeldingViewer::registerViewer();
    hkpInconsistentWindingViewer::registerViewer();
    hkpSingleBodyConstraintViewer::registerViewer();
}

hkpPhysicsContext::hkpPhysicsContext()
{

}

hkpPhysicsContext::~hkpPhysicsContext()
{
    for (int w=(m_worlds.getSize()-1); w >=0 ; --w)
    {
        removeWorld( m_worlds[w] );
    }
}

void hkpPhysicsContext::removeWorld( hkpWorld* oldWorld )
{
    int wi = m_worlds.indexOf(oldWorld);
    if (wi >= 0)
    {
        oldWorld->removeWorldDeletionListener(this);
        for (int i=0; i < m_addListeners.getSize(); ++i)
        {
            m_addListeners[i]->worldRemovedCallback(oldWorld);
        }

        m_worlds.removeAt(wi);
    }
}

void hkpPhysicsContext::addWorld( hkpWorld* newWorld )
{
    // make sure we don't have it already
    if (m_worlds.indexOf(newWorld) < 0)
    {
        newWorld->markForWrite();
            newWorld->addWorldDeletionListener(this);
        newWorld->unmarkForWrite();

        m_worlds.pushBack(newWorld);

        for (int i=0; i < m_addListeners.getSize(); ++i)
        {
            m_addListeners[i]->worldAddedCallback( newWorld );
        }
    }
}

int hkpPhysicsContext::findWorld(hkpWorld* world)
{
    return m_worlds.indexOf(world);
}

void hkpPhysicsContext::worldDeletedCallback( hkpWorld* world )
{
    removeWorld(world);
}

void hkpPhysicsContext::addWorldAddedListener( hkpPhysicsContextWorldListener* cb )
{
    if (m_addListeners.indexOf(cb)< 0)
    {
        m_addListeners.pushBack( cb );
    }
}

void hkpPhysicsContext::removeWorldAddedListener( hkpPhysicsContextWorldListener* cb )
{
    int index = m_addListeners.indexOf(cb);
    if (index >= 0 )
    {
        m_addListeners.removeAt( index );
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
