// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/hkpShapeType.h>
#include <Physics2012/Collide/Shape/hkpShapeContainer.h>

class hkpCollidable;
class hkDisplayGeometry;
class hkpShape;
class hkpSphereShape;
class hkpCapsuleShape;
class hkpCylinderShape;
class hkpBoxShape;
class hkpTriangleShape;
class hkpConvexVerticesShape;
class hkpListShape;
class hkpMultiSphereShape;
class hkpPlaneShape;
class hkpMultiRayShape;
class hkpConvexPieceShape;
class hkpExtendedMeshShape;
class hkpStorageExtendedMeshShape;
class hkpCompressedMeshShape;
class hkpBvCompressedMeshShape;
class hkpSampledHeightFieldShape;
class hkpShapeContinueData;
class hkpStaticCompoundShape;
struct hkGeometry;

    /// A utility class that creates hkDisplayGeometrys from hkCollidables and hkShapes.
    /// This class is used by the hkpShapeDisplayViewer.
class HK_EXPORT_PHYSICS_2012 hkpShapeDisplayBuilder : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VDB);

        struct HK_EXPORT_PHYSICS_2012 hkpShapeDisplayBuilderEnvironment
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VDB, hkpShapeDisplayBuilder::hkpShapeDisplayBuilderEnvironment );

            hkpShapeDisplayBuilderEnvironment();
            int m_sphereSubdivisions;
        };

        hkpShapeDisplayBuilder(const hkpShapeDisplayBuilderEnvironment& env);

            /// Creates an array of display geometries from a given shape.
        void buildDisplayGeometries( const hkpShape* shape, hkArray<hkDisplayGeometry*>& displayGeometries );

            /// Convert a geometry and send it to the hkDebugDisplay
        static void HK_CALL addObjectToDebugDisplay( const hkpShape* shape, hkTransform& t, hkUint64 id );

    public:

            /// Creates an array of display geometries from a given shape and a transform.
        void buildShapeDisplay( const hkpShape* shape, const hkTransform& transform,
                                hkArray<hkDisplayGeometry*>& displayGeometries, const hkVector4* scale = HK_NULL );

            /// Clears the current raw geometry. A temporary geometry is used to
            /// create display geometries triangle by triangle from a MOPP for example.
        void resetCurrentRawGeometry();

    public:
        // Convex shapes
        void buildShapeDisplay_Sphere( const hkpSphereShape* sphereShape, const hkTransform& transform,
                                       hkArray<hkDisplayGeometry*>& displayGeometries, const hkVector4* scale = HK_NULL );
        void buildShapeDisplay_Capsule( const hkpCapsuleShape* s, const hkTransform& transform,
                                        hkArray<hkDisplayGeometry*>& displayGeometries, const hkVector4* scale = HK_NULL );
        void buildShapeDisplay_Cylinder( const hkpCylinderShape* s, const hkTransform& transform,
                                         hkArray<hkDisplayGeometry*>& displayGeometries, const hkVector4* scale = HK_NULL );
        void buildShapeDisplay_Box( const hkpBoxShape* boxShape, const hkTransform& transform,
                                    hkArray<hkDisplayGeometry*>& displayGeometries, const hkVector4* scale = HK_NULL );
        void buildShapeDisplay_Triangle( const hkpTriangleShape* triangleShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries, const hkVector4* scale = HK_NULL );
        void buildShapeDisplay_ConvexVertices( const hkpConvexVerticesShape* shape, const hkTransform& transform,
                                               hkArray<hkDisplayGeometry*>& displayGeometries,
                                               const hkVector4* scale = HK_NULL );
        void buildShapeDisplay_StaticCompound( const hkpStaticCompoundShape* staticCompoundShape,
                                               const hkTransform& transform,
                                               hkArray<hkDisplayGeometry*>& displayGeometries,
                                               const hkVector4* scale = HK_NULL);

        // Compound shapes
        void buildShapeDisplay_ListShape( const hkpListShape* listShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );
        void buildShapeDisplay_CompressedMeshShape( const hkpCompressedMeshShape* compressedMeshShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );
        void buildShapeDisplay_BvCompressedMeshShape( const hkpBvCompressedMeshShape* bvCompressedMeshShape,
                                                      const hkTransform& transform,
                                                      hkArray<hkDisplayGeometry*>& displayGeometries,
                                                      const hkVector4* scale = HK_NULL);
        void buildShapeDisplay_ExtendedMeshShape( const hkpExtendedMeshShape* extendedMeshShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );
        void buildShapeDisplay_SampledHeightField( const hkpSampledHeightFieldShape* heightField, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );
        void buildShapeDisplay_ShapeContainer( const hkpShapeContainer* shapeContainer, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );

        // Other
        void buildShapeDisplay_MultiSphere( const hkpMultiSphereShape* s, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );
        void buildShapeDisplay_Plane( const hkpPlaneShape* planeShape, const hkTransform& tranform, hkArray<hkDisplayGeometry*>& displayGeometries );
        void buildShapeDisplay_MultiRay( const hkpMultiRayShape* s, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );

        // User shapes
            /// \return True if the shape was handled by a user shape display builder.
        hkBool buildShapeDisplay_UserShapes( const hkpShape* shape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );

        // Default for unregister shape types. Creates a hollow box around the aabb
        void buildShapeDisplay_ShapeUnregistered(const hkpShape* shape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries);

        // Deprecated
        void buildShapeDisplay_ConvexPiece( const hkpConvexPieceShape* triangulatedConvexShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );
    protected:
            /// Build the display geometry from an extended mesh shape with external storage.
        void buildShapeDisplayTriangleSubPartsCompress( const hkpExtendedMeshShape* extendedMeshShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );

            /// Build the display geometry from a storage extended mesh shape.
        void buildShapeDisplayTriangleSubPartsStorage( const hkpStorageExtendedMeshShape* extendedMeshShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );

            ///  Build the display geometry for the shape subparts of an extended mesh shape.
        void buildShapeDisplayShapeSubParts( const hkpExtendedMeshShape* extendedMeshShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );
//  protected:

public:
        hkDisplayGeometry* getCurrentRawGeometry( hkArray<hkDisplayGeometry*>& displayGeometries );

protected:

        hkpShapeDisplayBuilderEnvironment m_environment;
        hkDisplayGeometry* m_currentGeometry;
};

class HK_EXPORT_PHYSICS_2012 hkpUserShapeDisplayBuilder : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(hkpUserShapeDisplayBuilder, New, Singleton);

        hkpUserShapeDisplayBuilder() {}

            /// A function to build display geometries for user shapes. The function is expected to add hkDisplayGeometry objects
            /// to the displayGeometries list. It may call back the hkpShapeDisplayBuilder::buildDisplayGeometries() method on the
            /// builder object passed in to achieve this.
        typedef void (HK_CALL *ShapeBuilderFunction)(   const hkpShape* shape,
                                                        const hkTransform& transform,
                                                        hkArray<hkDisplayGeometry*>& displayGeometries,
                                                        hkpShapeDisplayBuilder* builder );

            /// You can register functions to build display for your own user types with the shape display builder using this method
        void registerUserShapeDisplayBuilder( ShapeBuilderFunction f, hkpShapeType type );

    public:

        struct UserShapeBuilder
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VDB, hkpUserShapeDisplayBuilder::UserShapeBuilder );

            ShapeBuilderFunction f;
            hkpShapeType type;
        };
        hkArray< UserShapeBuilder > m_userShapeBuilders;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
