// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpWorldViewerBase.h>

class hkpWorld;
class hkpMouseSpringAction;

/// Server side mouse picking implementation.
class HK_EXPORT_PHYSICS_2012 hkpMousePickingViewer : public hkpWorldViewerBase
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        static hkProcess* HK_CALL create(const hkArray<hkProcessContext*>& contexts);

            /// Registers the hkDebugDisplayProcess with the hkProcessFactory.
        static void HK_CALL registerViewer();

            /// Gets the tag associated with this viewer type
        virtual int getProcessTag() const HK_OVERRIDE { return s_tag; }

        static inline const char* HK_CALL getName() { return "Mouse Picking"; }


        //
        // Process interface
        //

        virtual void getConsumableCommands( hkUint8*& commands, int& numCommands ) HK_OVERRIDE;

            /// Given a command (that has already been parsed from
            /// the stream), consume the rest of the data.
        virtual void consumeCommand( hkUint8 command ) HK_OVERRIDE;

        virtual void worldRemovedCallback( hkpWorld* world ) HK_OVERRIDE;


        //
        // Own interface
        //

            /// Attaches a hkpMouseSpringAction to an object in the world
        hkBool grabObject( hkUint64 displayObject, const hkVector4& worldPosition );

            /// Move the fixed point of the hkpMouseSpringAction
        void dragObject( const hkVector4& newWorldSpacePoint );

            /// Removes the hkpMouseSpringAction from the world freeing the attached object.
        void releaseObject();

        /// Constructor, made public for internal demo use only.
        hkpMousePickingViewer(const hkArray<hkProcessContext*>& contexts);
        /// Destructor, made public for internal demo use only.
        ~hkpMousePickingViewer();

    protected:

        hkpWorld* m_currentWorld;
        hkpMouseSpringAction* m_mouseSpring;
        hkReal m_mouseSpringMaxRelativeForce;
        static int s_tag;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
