
// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/hkBase.h>
#include <Physics2012/Dynamics/World/Listener/hkpWorldDeletionListener.h>
#include <Physics2012/Utilities/VisualDebugger/hkpPhysicsContext.h>
#include <Common/Visualize/hkProcess.h>

class HK_EXPORT_PHYSICS_2012 hkpWorldViewerBase :  public hkReferencedObject,
                            public hkProcess,
                            protected hkpPhysicsContextWorldListener
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VDB);

        // Ctor will register as all the listeners
        hkpWorldViewerBase( const hkArray<hkProcessContext*>& contexts );

        // Dtor will unregister as all the listeners, from the context if any
        virtual ~hkpWorldViewerBase();

        // Sub classes should implement what they require from the following:

        //Process:
        virtual void getConsumableCommands( hkUint8*& commands, int& numCommands ) { commands = HK_NULL; numCommands = 0; }
        virtual void consumeCommand( hkUint8 command ) { }
        virtual void step( hkReal frameTimeInMs ) { /* nothing to do, driven by the simulation callbacks usually */ }

        //World deletion listener:
        virtual void worldRemovedCallback( hkpWorld* world ) { }

        //World added listener. Should impl this in sub class, but call up to this one to get the listener reg'd.
        virtual void worldAddedCallback( hkpWorld* world ) { }

    protected:

        hkpPhysicsContext* m_context;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
