// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Physics2012/Collide/hkpExport.h>
#include <Physics2012/Dynamics/World/hkpWorld.h>

//#define HK_DISABLE_DEBUG_DISPLAY
#include <Common/Visualize/hkProcessFactory.h>
#include <Common/Visualize/hkDebugDisplayHandler.h>
#include <Common/Visualize/hkProcessHandler.h>

#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpWorldSnapshotViewer.h>
#include <Physics2012/Utilities/Serialize/hkpHavokSnapshot.h>

#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>

#include <Common/Visualize/hkVisualDebuggerCmdType.h>
#include <Common/Visualize/hkServerFileHandler.h>

/* static */int hkpWorldSnapshotViewer::s_tags[TYPE_COUNT_OF];

void HK_CALL hkpWorldSnapshotViewer::registerViewer()
{
    s_tags[TYPE_BINARY_TAGFILE] = hkProcessFactory::getInstance().registerProcess( getNameBinaryTagfile(), createBinaryTagfile );
    s_tags[TYPE_XML_TAGFILE] = hkProcessFactory::getInstance().registerProcess( getNameXmlTagfile(), createXmlTagfile  );
}

hkProcess* HK_CALL hkpWorldSnapshotViewer::createBinaryTagfile(const hkArray<hkProcessContext*>& contexts)
{
    return new hkpWorldSnapshotViewer(contexts, TYPE_BINARY_TAGFILE);
}

hkProcess* HK_CALL hkpWorldSnapshotViewer::createXmlTagfile(const hkArray<hkProcessContext*>& contexts)
{
    return new hkpWorldSnapshotViewer(contexts, TYPE_XML_TAGFILE);
}

hkpWorldSnapshotViewer::hkpWorldSnapshotViewer(const hkArray<hkProcessContext*>& contexts, Type type)
: hkpWorldViewerBase( contexts),
m_type(type)
{

}

void hkpWorldSnapshotViewer::init()
{
    if (m_context)
    {
        for (int i=0; i < m_context->getNumWorlds(); ++i)
            worldAddedCallback( m_context->getWorld(i));
    }
}

hkpWorldSnapshotViewer::~hkpWorldSnapshotViewer()
{
    if (m_context)
    {
        for (int i=0; i < m_context->getNumWorlds(); ++i)
        {
            worldRemovedCallback( m_context->getWorld(i));
        }
    }
}

void hkpWorldSnapshotViewer::step( hkReal deltaTime )
{
    // step once, send the HKX file in full (in native console format, so less likely to hit any serialization issues)
    if (m_outStream)
    {
        hkArray<char> storage;
        storage.reserve( 100 * 1024 ); // 100KB
        hkArrayStreamWriter sw( &storage, hkArrayStreamWriter::ARRAY_BORROW );

        for ( int w = 0; w < m_context->getNumWorlds(); ++w )
        {
            storage.setSize( 0 );

            hkpHavokSnapshot::Options options( m_type == TYPE_BINARY_TAGFILE ? hkpHavokSnapshot::SNAPSHOT_BINARY_TAGFILE : hkpHavokSnapshot::SNAPSHOT_TEXT );
            hkpHavokSnapshot::save( m_context->getWorld( w ), &sw, options );

            const char* ext;
            if ( m_type == TYPE_BINARY_TAGFILE )
            {
                ext = "hkt";
            }
            else
            {
                ext = "xml";
            }

            m_fileHandler->sendFileData(
                storage.begin(),
                storage.getSize(),
                "Havok World Snapshot (2012)",
                hkArrayViewT::fromSingleObject( ext ),
                s_tags[m_type] );
        }
    }

    // Now we have done the work, we can turn ourselves off.
    if (m_processHandler)
    {
        m_processHandler->deleteProcess( s_tags[m_type]);

        //as our name has a '*' in it, the VDB clients will expect us to have deleted ourselves, so should be fine.
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
