// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpWorldViewerBase.h>
#include <Physics2012/Dynamics/Entity/hkpEntityListener.h>
#include <Physics2012/Dynamics/World/Listener/hkpWorldPostSimulationListener.h>

class hkpWorld;

/// Server side mouse picking implementation.
class HK_EXPORT_PHYSICS_2012 hkpSingleBodyConstraintViewer : public hkpWorldViewerBase, protected hkpWorldPostSimulationListener, public hkpEntityListener
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        static hkProcess* HK_CALL create(const hkArray<hkProcessContext*>& contexts);

            /// Registers the hkDebugDisplayProcess with the hkProcessFactory.
        static void HK_CALL registerViewer();

            /// Gets the tag associated with this viewer type
        virtual int getProcessTag() const HK_OVERRIDE { return s_tag; }

        static inline const char* HK_CALL getName() { return "Constraint Viewer - Single Body"; }

        virtual void postSimulationCallback( hkpWorld* world ) HK_OVERRIDE;


        //
        // Process interface
        //

        virtual void getConsumableCommands( hkUint8*& commands, int& numCommands ) HK_OVERRIDE;

            /// Given a command (that has already been parsed from
            /// the stream), consume the rest of the data.
        virtual void consumeCommand( hkUint8 command ) HK_OVERRIDE;

        virtual void worldRemovedCallback( hkpWorld* world ) HK_OVERRIDE;

        //
        // Entity listener interface
        //

            // We need to know when our picked body is no longer available to query constraints from
        virtual void entityRemovedCallback( hkpEntity* entity ) HK_OVERRIDE;
        virtual void entityDeletedCallback( hkpEntity* entity ) HK_OVERRIDE;


        //
        // Own interface
        //

            /// 'Binds' this viewer as listening to the picked rigid body so it may draw its constraints
        hkBool grabObject( hkUint64 displayObject, const hkVector4& worldPosition );

            /// Removes this object as an entity listener
        void releaseObject();


    protected:

        /// Constructor.
        hkpSingleBodyConstraintViewer(const hkArray<hkProcessContext*>& contexts);

        /// Destructor.
        ~hkpSingleBodyConstraintViewer();

        hkpWorld * m_currentWorld;
        // The body whose constraints are currently being displayed
        hkpRigidBody * m_pickedBody;

        static int s_tag;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
