// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpWorldViewerBase.h>
#include <Physics2012/Dynamics/World/Listener/hkpWorldPostSimulationListener.h>
#include <Physics2012/Dynamics/Phantom/hkpPhantomListener.h>
#include <Physics2012/Dynamics/Phantom/hkpPhantomType.h>
#include <Common/Visualize/Shape/hkDisplayAABB.h>

class hkDebugDisplayHandler;
class hkpWorld;
class hkpWorldObject;

    /// Displays all the entities in a world.
class HK_EXPORT_PHYSICS_2012 hkpPhantomDisplayViewer :  public hkpWorldViewerBase,
                                protected hkpPhantomListener, protected hkpWorldPostSimulationListener
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Creates a hkpPhantomDisplayViewer.
        static hkProcess* HK_CALL create(const hkArray<hkProcessContext*>& contexts);

            /// Registers the hkpPhantomDisplayViewer with the hkProcessFactory.
        static void HK_CALL registerViewer();

            /// Gets the tag associated with this viewer type
        virtual int getProcessTag() const HK_OVERRIDE { return s_tag; }

        virtual void init() HK_OVERRIDE;

        static inline const char* HK_CALL getName() { return "Phantoms"; }

    protected:

        hkpPhantomDisplayViewer(const hkArray<hkProcessContext*>& contexts);
        virtual ~hkpPhantomDisplayViewer();

        virtual void phantomAddedCallback( hkpPhantom* entity ) HK_OVERRIDE;
        virtual void phantomRemovedCallback( hkpPhantom* entity ) HK_OVERRIDE;
        virtual void postSimulationCallback( hkpWorld* world ) HK_OVERRIDE;

        virtual void worldAddedCallback( hkpWorld* world ) HK_OVERRIDE;
        virtual void worldRemovedCallback( hkpWorld* world ) HK_OVERRIDE;

    protected:

        void removeAllGeometries();
        void addWorld( hkpWorld* world );
        void removeWorld( hkpWorld* world );

    protected:

        static int s_tag;
        hkArray<hkpWorldObject*> m_phantomShapesCreated;
};

/// This singleton allows you to register hkPhantomTypes user types
/// as being hkShapePhantoms and thus allowing the auto display of the shapes held.
class HK_EXPORT_PHYSICS_2012 hkpUserShapePhantomTypeIdentifier : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(hkpUserShapePhantomTypeIdentifier, New, Singleton);

        hkpUserShapePhantomTypeIdentifier() {}

        void registerShapePhantomType( hkpPhantomType t );

    public:

        hkArray< hkpPhantomType > m_shapePhantomTypes;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
