// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpWorldViewerBase.h>
#include <Physics2012/Dynamics/Collide/ContactListener/hkpContactListener.h>

class hkDebugDisplayHandler;
class hkpWorld;
class hkListener;

    /// Draws TOI contact points in the VDB. Contact points are drawn as red
    /// arrows. See the userguide for more information.
class HK_EXPORT_PHYSICS_2012 hkpToiContactPointViewer
    : public hkpWorldViewerBase
    , public hkpContactListener
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VDB);

        virtual void init();

        static const char* getName() { return "Contact Points (TOI)"; }
        static hkProcess* HK_CALL create(const hkArray<hkProcessContext*>& contexts);
        static void HK_CALL registerViewer();

        int getProcessTag() const;

        virtual void contactPointCallback( const hkpContactPointEvent& event );

    protected:
        hkpToiContactPointViewer(const hkArray<hkProcessContext*>& contexts);
        virtual ~hkpToiContactPointViewer();
        virtual void worldAddedCallback  ( hkpWorld* world );
        virtual void worldRemovedCallback( hkpWorld* world );

        static int s_tag;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
