// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpWorldViewerBase.h>
#include <Physics2012/Dynamics/World/Listener/hkpWorldPostSimulationListener.h>
#include <Physics2012/Dynamics/Entity/hkpEntityListener.h>
#include <Common/Base/Container/PointerMap/hkPointerMap.h>
#include <Common/Visualize/hkDebugDisplayHandler.h>

class hkpWorld;
class hkpShapeDisplayBuilder;

class hkpCollidable;

#define HK_DISPLAY_VIEWER_OPTIONS_CONTEXT "ShapeDisplayViewerOptions"

    /// Displays all the entities in a world.
class HK_EXPORT_PHYSICS_2012 hkpShapeDisplayViewer :    public hkpWorldViewerBase,
                                protected hkpEntityListener, public hkpWorldPostSimulationListener
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Creates a hkpShapeDisplayViewer.
        static hkProcess* HK_CALL createShapeViewer( const hkArray<hkProcessContext*>& contexts );

            /// Creates a hkpShapeDisplayViewer that only displays trigger volumes
        static hkProcess* HK_CALL createTriggerVolumeViewer( const hkArray<hkProcessContext*>& contexts );

            /// Registers the hkpShapeDisplayViewer with the hkProcessFactory.
        static void HK_CALL registerViewer();

            /// Gets the tag associated with this viewer type
        virtual int getProcessTag() const HK_OVERRIDE { return m_tag; }

        virtual void init() HK_OVERRIDE;

        static inline const char* HK_CALL getName() { return "Shapes"; }

        virtual void synchronizeTransforms( class hkDebugDisplayHandler* displayHandler, hkpWorld* world );

        virtual void synchronizeTransforms(hkpWorld* world);

            /// By default the world current time is used for display, but you can
            /// set this to a different value if for example you are half - stepping the world
            /// using the integrate() and collide() functions, and want to display interpolated transforms
            /// between these calls
        void setTimeForDisplay( hkTime time ) { m_timeForDisplay = time; }

        void setDisplayBodyCreateEnabled( bool on ); // default : true, otherwise you handler will have to have precreated ones for it
        bool getDisplayBodyCreateEnabled( ) const { return m_enableDisplayCreation; }

        void setInstancingEnabled( bool on ); // default : false
        bool getInstancingEnabled( ) const { return m_enableInstancing; }

        void setAutoColorMode( bool on ); // default: true
        bool getAutoColorMode( ) const { return m_enableAutoColor; }

        void setAutoColorModeOverride( bool on ) { m_enableAutoColorOverride = on; } // default: false
        bool getAutoColorModeOverride( ) const { return m_enableAutoColorOverride; }

        void setDisplayBodyCachingEnabled( bool on ); // default : false
        bool getDisplayBodyCachingEnabled( ) const { return m_enableDisplayCaching; }
        void clearCache();

        void setAutoGeometryCreation( bool on ); // default : true
        bool getAutoGeometryCreation( ) const { return m_autoGeometryCreation; }

        // These will only affect objects added after this call
        // Only used whene AutoColorMode is true and rb does not have a color prop itself (unless override is on)
        inline void setMovableObjectColor( hkUint32 c) { m_movableObjectColor = c; }
        inline void setFixedObjectColor( hkUint32 c) { m_fixedObjectColor = c; }
    public:

        class ShapeDisplayViewerOptions: public hkReferencedObject, public hkProcessContext
        {
            public:
                HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
                virtual const char* getType(){ return HK_DISPLAY_VIEWER_OPTIONS_CONTEXT; }
                ShapeDisplayViewerOptions(): m_enableShapeTransformUpdate(true){}
                hkBool m_enableShapeTransformUpdate;
        };

    public:
        virtual void worldAddedCallback( hkpWorld* world ) HK_OVERRIDE;
        virtual void worldRemovedCallback( hkpWorld* world ) HK_OVERRIDE;

    protected:

        // Function pointer to a function that decides whether an entity is to be
        // displayed by this viewer. Return false if the entity is not to be displayed
        typedef hkBool (HK_CALL *IsDisplayableFunction)(hkpEntity*);
        IsDisplayableFunction m_isDisplayable;

        int m_tag;

        hkpShapeDisplayViewer( const hkArray<hkProcessContext*>& contexts, int processTag, IsDisplayableFunction display );

        virtual ~hkpShapeDisplayViewer();

    public:
        virtual void entityAddedCallback( hkpEntity* entity ) HK_OVERRIDE;
        virtual void entityRemovedCallback( hkpEntity* entity ) HK_OVERRIDE;
        virtual void postSimulationCallback( hkpWorld* world ) HK_OVERRIDE;
        virtual void entityShapeSetCallback( hkpEntity* entity ) HK_OVERRIDE;
        virtual void inactiveEntityMovedCallback( hkpEntity* entity ) HK_OVERRIDE;

        void addWorld( hkpWorld* world );
        int findWorld( const hkpWorld* world );

        void removeWorld( int worldIndex );
        void removeAllGeometries( int worldIndex );

        struct WorldToEntityData
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VDB, WorldToEntityData);
            hkpWorld* world;
            hkArray<hkUint64> entitiesCreated;
        };

        hkArray< WorldToEntityData* > m_worldEntities;

        typedef hkPointerMap< const class hkpShape*, hkUint64 > ShapeMap;
        ShapeMap m_instancedShapeToGeomID;
        ShapeMap m_instancedShapeToUsageCount;
        ShapeMap m_cachedShapes;

        hkBool m_enableShapeTransformUpdate;
        hkBool m_enableInstancing;
        hkBool m_enableDisplayCaching;
        hkBool m_enableDisplayCreation;
        hkBool m_autoGeometryCreation;
        hkBool m_enableAutoColor;
        hkBool m_enableAutoColorOverride;
        hkTime m_timeForDisplay;

        hkColor::Argb m_fixedObjectColor;
        hkColor::Argb m_movableObjectColor;

        static hkBool isTriggerVolume(hkpEntity* entity);
        static hkBool isShape(hkpEntity* entity);

    public:
        static inline hkUint64 HK_CALL getId( hkpWorldObject* worldObject )
        {
            return (worldObject->hasProperty(HK_PROPERTY_DEBUG_DISPLAY_ID)) ?
                hkUint64(worldObject->getProperty(HK_PROPERTY_DEBUG_DISPLAY_ID).getInt()) : hkUint64(worldObject->getCollidable());
        }
    public:

        static int s_tagShapeViewer;
        static int s_tagTriggerVolumeViewer;

    protected:
        hkpShapeDisplayBuilder* m_builder;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
