// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpContactPointViewer.h>

    /// Displays the contact points contained in the inactive simulation
    /// islands in the world.
    /// The contact points are drawn in green.
class HK_EXPORT_PHYSICS_2012 hkpInactiveContactPointViewer : public hkpContactPointViewer
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VDB);

            /// Gets the tag associated with this viewer type
        virtual int getProcessTag() const HK_OVERRIDE { return s_tag; }

            /// Creates a hkpContactPointViewer.
        static hkProcess* HK_CALL create(const hkArray<hkProcessContext*>& contexts);

            /// Registers the hkpContactPointViewer with the hkProcessFactory.
        static void HK_CALL registerViewer();

        static inline const char* HK_CALL getName() { return "Contact Points (Inactive)"; }

    protected:

        const hkArray<hkpSimulationIsland*>& getIslands(hkpWorld* world) const HK_OVERRIDE;

        static int s_tag;

        hkpInactiveContactPointViewer(const hkArray<hkProcessContext*>& contexts);
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
