// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Physics2012/Collide/hkpExport.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpInactiveContactPointViewer.h>
#include <Physics2012/Dynamics/World/hkpWorld.h>
#include <Physics2012/Collide/Agent3/Machine/Nn/hkpAgentNnMachine.h>
#include <Common/Visualize/hkProcessFactory.h>
#include <Common/Base/Types/Color/hkColor.h>

int hkpInactiveContactPointViewer::s_tag = 0;

void HK_CALL hkpInactiveContactPointViewer::registerViewer()
{
    s_tag = hkProcessFactory::getInstance().registerProcess( getName(), create );
}

hkProcess* HK_CALL hkpInactiveContactPointViewer::create(const hkArray<hkProcessContext*>& contexts)
{
    return new hkpInactiveContactPointViewer(contexts);
}

hkpInactiveContactPointViewer::hkpInactiveContactPointViewer(const hkArray<hkProcessContext*>& contexts)
: hkpContactPointViewer( contexts, hkColor::GREEN )
{
}

const hkArray<hkpSimulationIsland*>& hkpInactiveContactPointViewer::getIslands(hkpWorld* world) const
{
    return world->getInactiveSimulationIslands();
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
