// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Color/hkColor.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpWorldViewerBase.h>
#include <Physics2012/Dynamics/World/Listener/hkpWorldPostSimulationListener.h>
#include <Physics2012/Dynamics/Entity/hkpEntityListener.h>

class hkDebugDisplayHandler;
class hkpWorld;
class hkpConvexRadiusBuilder;

class hkpCollidable;

/// Displays all the entities in a world, but only ones
/// with convex radius and expands the object to show that radius
class HK_EXPORT_PHYSICS_2012 hkpConvexRadiusViewer :    public hkpWorldViewerBase,
                                protected hkpEntityListener, protected hkpWorldPostSimulationListener
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Creates a hkpConvexRadiusViewer.
        static hkProcess* HK_CALL create( const hkArray<hkProcessContext*>& contexts );

            /// Registers the hkpConvexRadiusViewer with the hkProcessFactory.
        static void HK_CALL registerViewer();

            /// Gets the tag associated with this viewer type
        virtual int getProcessTag() const HK_OVERRIDE { return s_tag; }

        virtual void init() HK_OVERRIDE;

        static inline const char* HK_CALL getName() { return "Convex Radius"; }

        // These will only affect objects added after this call
        inline void setMovableObjectColor( hkUint32 c) { m_movableObjectColor = c; }
        inline void setFixedObjectColor( hkUint32 c) { m_fixedObjectColor = c; }

        // Hack: internal method used by Destruction in the Preview Tool. Search for [0xaf5511e1] or see COM-1312 for more details.
        void setMinimumVisibleRadius(hkReal radius);

    protected:

        hkpConvexRadiusViewer( const hkArray<hkProcessContext*>& contexts );
        virtual ~hkpConvexRadiusViewer();

        virtual void entityAddedCallback( hkpEntity* entity ) HK_OVERRIDE;
        virtual void entityRemovedCallback( hkpEntity* entity ) HK_OVERRIDE;
        virtual void postSimulationCallback( hkpWorld* world ) HK_OVERRIDE;

        virtual void worldAddedCallback( hkpWorld* world ) HK_OVERRIDE;
        virtual void worldRemovedCallback( hkpWorld* world ) HK_OVERRIDE;

        void addWorld( hkpWorld* world );
        int findWorld( const hkpWorld* world );

        void removeWorld( int worldIndex );
        void removeAllGeometries( int worldIndex );

        void inactiveEntityMovedCallback( hkpEntity* entity ) HK_OVERRIDE;

        struct WorldToEntityData {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VDB, WorldToEntityData);
            hkpWorld* world;
            hkArray<hkUint64> entitiesCreated;
        };

        hkArray< WorldToEntityData* > m_worldEntities;
        static int s_tag;

        hkColor::Argb m_fixedObjectColor;
        hkColor::Argb m_movableObjectColor;

    protected:
        hkpConvexRadiusBuilder* m_builder;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
