// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/hkpShapeType.h>

class hkpCollidable;
class hkDisplayGeometry;
class hkpShape;
class hkpCylinderShape;
class hkpBoxShape;
class hkpTriangleShape;
class hkpConvexVerticesShape;
class hkpConvexPieceShape;
class hkpShapeContinueData;
class hkpShapeContainer;
class hkpConvexTransformShape;


    /// A utility class that creates hkDisplayGeometrys from hkCollidables and hkShapes.
    /// This class is used by the hkpConvexRadiusViewer and automatically expands any object
    /// with convex radius by that amount. Any object that does not use a convex radius
    /// will be ignored and if the radius is below m_minVisibleRadius it will be ignored too.
class HK_EXPORT_PHYSICS_2012 hkpConvexRadiusBuilder : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VDB);

        struct HK_EXPORT_PHYSICS_2012 hkpConvexRadiusBuilderEnvironment
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VDB, hkpConvexRadiusBuilder::hkpConvexRadiusBuilderEnvironment );

            hkpConvexRadiusBuilderEnvironment();
            float m_minVisibleRadius; // below this no display is created (== the normal body display anyway so not much use)
        };

        hkpConvexRadiusBuilder(const hkpConvexRadiusBuilderEnvironment& env);

            /// Creates an array of display geometries from a given collidable.
        void buildDisplayGeometries(        const hkpShape* shape,
                                            hkArray<hkDisplayGeometry*>& displayGeometries);

            /// Creates an array of display geometries from a given shape and a transform.
        void buildShapeDisplay(             const hkpShape* shape,
                                            const hkTransform& transform,
                                            hkArray<hkDisplayGeometry*>& displayGeometries,
                                            const hkVector4* scale = HK_NULL );

            /// Clears the current raw geometry. A temporary geometry is used to
            /// create display geometries triangle by triangle from a MOPP for example.
        void resetCurrentRawGeometry();

        // Hack: internal method used by Destruction in the Preview Tool. Search for [0xaf5511e1] or see COM-1312 for more details.
        void setMinimumVisibleRadius(hkReal radius) { m_environment.m_minVisibleRadius = hkFloat32(radius); }

    public:
        // Convex shapes
        void buildShapeDisplay_Cylinder( const hkpCylinderShape* s, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries, const hkVector4* scale );
        void buildShapeDisplay_Box( const hkpBoxShape* boxShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries, const hkVector4* scale );
        void buildShapeDisplay_Triangle( const hkpTriangleShape* triangleShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries, const hkVector4* scale );
        void buildShapeDisplay_ConvexVertices( const hkpConvexVerticesShape* convexVerticesShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries);

        // Transform shapes
        void buildShapeDisplay_ConvexTransform( const hkpConvexTransformShape* convexTransformShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );

        // Compound shapes
        void buildShapeDisplay_ShapeContainer( const hkpShapeContainer* shapeContainer, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );

        // User shapes
        hkBool buildShapeDisplay_UserShapes( const hkpShape* shape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );

        // Deprecated
        void buildShapeDisplay_ConvexPiece( const hkpConvexPieceShape* triangulatedConvexShape, const hkTransform& transform, hkArray<hkDisplayGeometry*>& displayGeometries );

    protected:

        hkDisplayGeometry* getCurrentRawGeometry(hkArray<hkDisplayGeometry*>& displayGeometries);

    protected:

        hkpConvexRadiusBuilderEnvironment m_environment;
        hkDisplayGeometry* m_currentGeometry;


};

class HK_EXPORT_PHYSICS_2012 hkpUserConvexRadiusBuilder : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(hkpUserConvexRadiusBuilder, New, Singleton);

        hkpUserConvexRadiusBuilder() {}

            /// A function to build display geometries for user shapes. The function is expected to add hkDisplayGeometry objects
            /// to the displayGeometries list. It may call back the hkpConvexRadiusBuilder::buildDisplayGeometries() method on the
            /// builder object passed in to achieve this.
        typedef void (HK_CALL *ConvexRadiusBuilderFunction)(    const hkpShape* shape,
                                                        const hkTransform& transform,
                                                        hkArray<hkDisplayGeometry*>& displayGeometries,
                                                        hkpConvexRadiusBuilder* builder );

            /// You can register functions to build display for your own user types with the shape display builder using this method
        void registerUserConvexRadiusDisplayBuilder( ConvexRadiusBuilderFunction f, hkpShapeType type );

    public:

        struct UserShapeBuilder
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VDB, hkpUserConvexRadiusBuilder::UserShapeBuilder );

            ConvexRadiusBuilderFunction f;
            hkpShapeType type;
        };
        hkArray< UserShapeBuilder > m_userConvexRadiusBuilders;


};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
