// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

//#define HK_DISABLE_DEBUG_DISPLAY
#include <Common/Visualize/hkDebugDisplay.h>
#include <Common/Visualize/hkDebugDisplayHandler.h>

#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>

/// A utility class for drawing OBBs and AABBs as debug lines. They can be
/// output to the generic debug display or sent directly to a display handler.
class HK_EXPORT_PHYSICS_2012 hkpCollideDebugUtil
{
    public:
            /// Draws an OBB as a series of debug lines.
        static void HK_CALL drawObbLines(const hkTransform& t, const hkVector4& halfExtents, hkColor::Argb color, hkDebugDisplayHandler* displayHandler = HK_NULL, hkUint64 id = 0, int tag = 0)
        {
#ifndef HK_DISABLE_DEBUG_DISPLAY
            // draw the lines

            hkVector4 points[8];
            // points
            {
                for (int i = 0; i < 8; i++)
                {
                    hkVector4 v = halfExtents;
                    if ( i & 1 )    v(0) *= -1.0f;
                    if ( i & 2 )    v(1) *= -1.0f;
                    if ( i & 4 )    v(2) *= -1.0f;
                    points[i].setTransformedPos(t, v);
                }
            }

            // edges

            {
                for (int i = 0; i < 8; i++)
                {
                    for ( int bit = 1; bit < 8; bit <<= 1 )
                    {
                        int j = i ^ bit;
                        if ( i < j )
                        {
                            hkVector4 start = points[i];
                            hkVector4 end = points[j];

                            if(displayHandler)
                            {
                                displayHandler->displayLine(id, start, end, color, tag);
                            }
                            else
                            {
                                hkDebugDisplay::getInstance().displayLine(id, start, end, color, tag);
                            }
                        }
                    }
                }
            }
#endif
        }

            /// Draws an array of AABBs as a series of debug lines.
        static void HK_CALL displayAabbs(hkArray<hkAabb>& aabbs, hkColor::Argb color, hkDebugDisplayHandler* displayHandler = HK_NULL, hkUint64 id = 0, int tag = 0)
        {
#ifndef HK_DISABLE_DEBUG_DISPLAY
            for(int i=0; i<aabbs.getSize(); i++)
            {
                hkAabb aabb = aabbs[i];

                {
                    hkTransform t;
                    t.setIdentity();
                    hkVector4 centre = aabb.m_min;
                    centre.add(aabb.m_max);
                    centre.mul(hkSimdReal_Inv2);
                    t.setTranslation(centre);

                    hkVector4 halfExtents = aabb.m_max;
                    halfExtents.sub(aabb.m_min);
                    halfExtents.mul(hkSimdReal_Inv2);

                    drawObbLines(t, halfExtents, color, displayHandler, id, tag);
                }
            }
#endif
        }
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
