// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Physics2012/Collide/hkpExport.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>

#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>

#include <Physics2012/Utilities/Serialize/hkpPhysicsData.h>
#include <Physics2012/Utilities/Serialize/hkpHavokSnapshot.h>
#include "Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h"
#include "../../../Collide/Shape/Convex/Box/hkpBoxShape.h"
#include "../../../Collide/Shape/HeightField/SampledHeightField/hkpSampledHeightFieldShape.h"
#include <Physics2012/Collide/Shape/HeightField/TriSampledHeightField/hkpTriSampledHeightFieldBvTreeShape.h>
#include <Physics2012/Collide/Shape/HeightField/TriSampledHeightField/hkpTriSampledHeightFieldCollection.h>
//#include "../../../Collide/Shape/HeightField/TriSampledHeightField/hkpTriSampledHeightFieldBvTreeShape.h"
//#include "../../../Collide/Shape/HeightField/TriSampledHeightField/hkpTriSampledHeightFieldCollection.h"
#include <Physics2012/Collide/Filter/hkpCollisionFilter.h>


static hkpWorld* createNewWorld()
{
    hkpWorldCinfo info;
    info.m_gravity.set(0.0f, -9.8f, 0.0f);
    info.setBroadPhaseWorldSize(1000.0f);
    info.m_collisionTolerance = 0.01f;

    return new hkpWorld(info);
}

static void saveAndLoadSnapshot(hkpWorld* world)
{
    hkArray<char> ar;
    hkArrayStreamWriter writer(&ar, hkArrayStreamWriter::ARRAY_BORROW);

    if( HK_TEST(hkpHavokSnapshot::save(world, &writer)) )
    {
        hkMemoryStreamReader reader(ar.begin(), ar.getSize(), hkMemoryStreamReader::MEMORY_INPLACE);

        hkResource* resData = HK_NULL;
        hkpPhysicsData* data = hkpHavokSnapshot::load(&reader, &resData);

        if( HK_TEST(resData != HK_NULL && data != HK_NULL) )
        {
            hkpWorld* newWorld = data->createWorld();
            HK_TEST(newWorld != HK_NULL);
            newWorld->removeReference();
        }

        resData->removeReference();
    }
}

// ------------------------------------------------------------------------------------------------------------------ //

static void testBoxShape()
{
    hkpWorld* world = createNewWorld();

    hkpRigidBody* body;
    {
        // create shape
        hkVector4 fixedBoxSize; fixedBoxSize.set(5.0f, .5f , 5.0f );
        hkpBoxShape* fixedBoxShape = new hkpBoxShape( fixedBoxSize , 0 );

        // create rigid body info
        hkpRigidBodyCinfo info;
        info.m_shape = fixedBoxShape;
        info.m_motionType = hkpMotion::MOTION_FIXED;

        body = new hkpRigidBody(info);

        // release handle to shape
        fixedBoxShape->removeReference();
    }

    world->markForWrite();
    world->addEntity(body);
    world->unmarkForWrite();
    body->removeReference();

    saveAndLoadSnapshot(world);

    world->removeReference();
}

// ------------------------------------------------------------------------------------------------------------------ //

// A very simple procedural heightfield shape. See the sampledheightfieldapi demo for more details on the heightfield shape.
class SimpleSampledHeightFieldShape: public hkpSampledHeightFieldShape
{
public:

    SimpleSampledHeightFieldShape( const hkpSampledHeightFieldBaseCinfo& ci ): hkpSampledHeightFieldShape(ci)
    {
    }

    HK_INLINE hkReal getHeightAtImpl( int x, int z ) const
    {
        // Create a flat heightfield with a single bump
        if ( x == 3 )
        {
            return 3;
        }
        else
        {
            return 0;
        }
    }
    HK_INLINE hkBool getTriangleFlipImpl() const
    {
        return false;
    }

    virtual void collideSpheres( const CollideSpheresInput& input, SphereCollisionOutput* outputArray) const
    {
        hkSampledHeightFieldShape_collideSpheres(*this, input, outputArray);
    }
};

static void testSampledHeightFieldShape()
{
    hkpWorld* world = createNewWorld();

    hkpRigidBody* body;
    {
        // create shape
        hkpSampledHeightFieldBaseCinfo ci;
        ci.m_xRes = 7;
        ci.m_zRes = 7;
        SimpleSampledHeightFieldShape* heightFieldShape = new SimpleSampledHeightFieldShape( ci );

        // create rigid body info
        hkpRigidBodyCinfo info;
        info.m_shape = heightFieldShape;
        info.m_motionType = hkpMotion::MOTION_FIXED;

        body = new hkpRigidBody(info);

        // release handle to shape
        heightFieldShape->removeReference();
    }

    world->markForWrite();
    world->addEntity(body);
    world->unmarkForWrite();
    body->removeReference();

    saveAndLoadSnapshot(world);

    world->removeReference();
}

static void testTriSampledHeightFieldShape()
{
    hkpWorld* world = createNewWorld();

    hkpRigidBody* body;
    {
        // create shape
        hkpSampledHeightFieldBaseCinfo ci;
        ci.m_xRes = 7;
        ci.m_zRes = 7;
        SimpleSampledHeightFieldShape* heightFieldShape = new SimpleSampledHeightFieldShape( ci );

        // Wrap the heightfield in a hkpTriSampledHeightFieldCollection:
        hkpTriSampledHeightFieldCollection* collection = new hkpTriSampledHeightFieldCollection( heightFieldShape );

        // Now wrap the hkpTriSampledHeightFieldCollection in a hkpTriSampledHeightFieldBvTreeShape
        hkpTriSampledHeightFieldBvTreeShape* bvTree = new hkpTriSampledHeightFieldBvTreeShape( collection );

        // create rigid body info
        hkpRigidBodyCinfo info;
        info.m_shape = bvTree;
        info.m_motionType = hkpMotion::MOTION_FIXED;

        body = new hkpRigidBody(info);

        // release handle to shape
        heightFieldShape->removeReference();
        collection->removeReference();
        bvTree->removeReference();
    }

    world->markForWrite();
    world->addEntity(body);
    world->unmarkForWrite();
    body->removeReference();

    saveAndLoadSnapshot(world);

    world->removeReference();
}

namespace
{
    struct NonReflectedCollisionFilter : public hkpCollisionFilter
    {
        HK_DECLARE_CLASS(NonReflectedCollisionFilter, New, NoReflect2(hkpCollisionFilter));

        NonReflectedCollisionFilter() { m_type = HK_FILTER_CUSTOM; }

        virtual hkBool isCollisionEnabled(const hkpCollidable& a, const hkpCollidable& b) const { return true; }

        virtual hkBool isCollisionEnabled(const hkpCollisionInput& input, const hkpCdBody& a, const hkpCdBody& b,
            const HK_SHAPE_CONTAINER& bContainer, hkpShapeKey bKey) const
        {
            return true;
        }

        virtual hkBool isCollisionEnabled(const hkpCollisionInput& input, const hkpCdBody& collectionBodyA,
            const hkpCdBody& collectionBodyB, const HK_SHAPE_CONTAINER& containerShapeA,
            const HK_SHAPE_CONTAINER& containerShapeB,
            hkpShapeKey keyA, hkpShapeKey keyB) const
        {
            return true;
        }

        virtual hkBool isCollisionEnabled(const hkpShapeRayCastInput& aInput, const HK_SHAPE_CONTAINER& bContainer,
            hkpShapeKey bKey) const
        {
            return true;
        }

        virtual hkBool isCollisionEnabled(const hkpWorldRayCastInput& a, const hkpCollidable& collidableB) const
        {
            return true;
        }
    };
}

static void testNonReflected()
{
    hkpWorldCinfo info;
    info.m_collisionFilter.setAndDontIncrementRefCount(new NonReflectedCollisionFilter());

    hkpWorld world(info);
    saveAndLoadSnapshot(&world);
}

int worldSnapshot_main()
{
    testBoxShape();
    testSampledHeightFieldShape();
    testTriSampledHeightFieldShape();
    testNonReflected();

    return 0;
}

HK_TEST_REGISTER(worldSnapshot_main, "Native", "Physics2012/Test/UnitTest/Utilities/", __FILE__ );

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
