// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/UnitTest/hkUnitTest.h>

#include <Physics2012/Collide/Shape/Convex/Box/hkpBoxShape.h>
#include <Physics2012/Utilities/Collide/TriggerVolume/hkpTriggerVolume.h>
#include <Physics2012/Collide/Dispatch/hkpAgentRegisterUtil.h>


class UnitTestTriggerVolume : public hkpTriggerVolume
{
public:
    UnitTestTriggerVolume( hkpRigidBody* triggerBody, int numExpectedEvents, hkpTriggerVolume::EventType* expectedEvents )
        : hkpTriggerVolume( triggerBody ), m_numExpectedEvents( numExpectedEvents ), m_expectedEvents( expectedEvents ), m_eventCount( 0 )
    {

    }

    using hkpTriggerVolume::triggerEventCallback;

    virtual void triggerEventCallback( hkpRigidBody* body, EventType type )
    {
        if ( m_eventCount < m_numExpectedEvents )
        {
            HK_TEST( m_expectedEvents[m_eventCount] == type );
        }
        ++m_eventCount;
    }

    ~UnitTestTriggerVolume()
    {
        HK_TEST( m_eventCount == m_numExpectedEvents );
    }

public:
    int m_numExpectedEvents;
    hkpTriggerVolume::EventType* m_expectedEvents;
    int m_eventCount;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
