// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Dynamics/World/hkpWorldCinfo.h>
#include <Physics2012/Dynamics/World/hkpPhysicsSystem.h>

class hkpWorld;

/// This is the top level container class for physics systems
class HK_EXPORT_PHYSICS_2012 hkpPhysicsData : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_UTILITIES);
        HK_DECLARE_REFLECTION();

            /// Default constructor
        hkpPhysicsData();

            /// Default destructor - dereferences any data
        virtual ~hkpPhysicsData()
        {
            if ( m_worldCinfo != HK_NULL )
            {
                m_worldCinfo->removeReference();
            }


            for (int p=0; p < m_systems.getSize(); ++p)
            {
                m_systems[p]->removeReference();
            }
        }

        //
        // Accessors.
        //

            /// Get the world cinfo of the data
        inline hkpWorldCinfo* getWorldCinfo();

            /// Set the world cinfo of the data
        inline void setWorldCinfo( hkpWorldCinfo* info );

            /// Add a physics system to the data.
            /// This adds a reference to the system
        inline void addPhysicsSystem( hkpPhysicsSystem* system );

            /// Remove a physics system from the data.
            /// This removes a reference from the system
        inline void removePhysicsSystem( int i );

            /// Get a const list of physics systems
        inline const hkArray<hkpPhysicsSystem*>& getPhysicsSystems() const;

            /// Look for a physics system by name (case insensitive)
        hkpPhysicsSystem* findPhysicsSystemByName (const char* name) const;

            /// Look for a rigid body by name (case insensitive)
        hkpRigidBody* findRigidBodyByName (const char* name) const;

        //
        // Utility Functions
        //


            /// Fill in systems from a live hkpWorld object
        void populateFromWorld( const hkpWorld* world, bool saveContactPoints = false );

            /// Utility function to convert the cinfo and systems
            /// into an actual world.
            /// Before the bodies are added to the world, it is usually
            /// desired that all agents are registered (or overlapping pairs
            /// will not be dealt with correctly at the start). If you wish
            /// to register only your own subset (to reduce code size)
            /// then copy the code from this func and make your own create util func.
        hkpWorld* createWorld(hkBool registerAllAgents = true);

            /// Structure returned by splitPhysicsSystems()
        struct SplitPhysicsSystemsOutput
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES, hkpPhysicsData::SplitPhysicsSystemsOutput );

            /// One system for unconstrained fixed rigid bodies
            hkpPhysicsSystem* m_unconstrainedFixedBodies;
            /// One system for unconstrained keyframed bodies
            hkpPhysicsSystem* m_unconstrainedKeyframedBodies;
            /// One system for unconstrained moving bodies
            hkpPhysicsSystem* m_unconstrainedMovingBodies;
            /// One system to contain all the phantoms in the input system
            hkpPhysicsSystem* m_phantoms;
            /// One system per group of constrained bodies (such as a ragdoll)
            hkArray<hkpPhysicsSystem*> m_constrainedSystems;
        };

            /// Utility function to split one physics system into a group of systems.
            /// The user data pointer of the input system is set to the user data for all systems created.
            ///
            /// This converts the system into:
            /// One system for unconstrained fixed rigid bodies.
            /// One system for unconstrained keyframed bodies.
            /// One system for unconstrained moving bodies.
            /// One system per group of constrained bodies (such as a ragdoll).
            /// One system to contain all the phantoms in the input system.
            /// The user data pointer of the input system is set to the user data for all systems created
        static void splitPhysicsSystems(const hkpPhysicsSystem* inputSystemConst, SplitPhysicsSystemsOutput& output );

    protected:

            /// The world data. Reference counted.
        class hkpWorldCinfo* m_worldCinfo;

            /// A list of physics systems.
        hkArray<class hkpPhysicsSystem*> m_systems;
};

#include <Physics2012/Utilities/Serialize/hkpPhysicsData.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
