// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Serialize/hkSerialize.h>

class hkResource;
class hkFilterObjectProvider;

/// This is a simple way to snapshot (serialize) the whole scene into a file.
/// This can be useful for debugging purposes.
class HK_EXPORT_PHYSICS_2012 hkpHavokSnapshot
{
    public:
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkpHavokSnapshot);

            /// By default, a binary tagfile snapshot is generated.
            /// Settings any of these options overrides this default
        enum SnapshotOptionsBits
        {
            SNAPSHOT_BINARY_TAGFILE = 0, ///< Default, binary tagfile
            SNAPSHOT_TEXT = 1, ///< Output an XML snapshot
            SNAPSHOT_PACKFILE = 2, ///< Output a packfile snapshot
        };

        struct Options : public hkFlags<SnapshotOptionsBits, int>
        {
            Options(SnapshotOptionsBits b = SNAPSHOT_BINARY_TAGFILE) : hkFlags<SnapshotOptionsBits, int>(b) {}
            // Convert from the old option: hkBool binaryFormat
            Options(bool b) : hkFlags<SnapshotOptionsBits, int>(b ? SNAPSHOT_BINARY_TAGFILE : SNAPSHOT_TEXT) {}
        };

            /// Save a snapshot of the world to filename in tagfile form (binary).
            /// Returns true on success.
            /// If you don't provide a target layout then the current host layout is assumed.
            /// NOTE: some objects are inherently not serializable because they point to
            /// external memory, i.e., the vertex and index arrays of an hkpMeshShape. When these objects
            /// are encountered, we convert them before saving, i.e., hkpMeshShape -> hkpStorageMeshShape.
        static hkBool HK_CALL save(const class hkpWorld* world, hkStreamWriter* writer,
            Options outputOptions = SNAPSHOT_BINARY_TAGFILE,
            const char* targetLayout = HK_NULL,
            bool saveContactPoints = false );

            /// Save a snapshot of a hkpPhysicsData to filename.
        static hkBool HK_CALL save( const class hkpPhysicsData* data, hkStreamWriter* writer,
            Options outputOptions = SNAPSHOT_BINARY_TAGFILE,
            const char* targetLayout = HK_NULL );

        /// Save a snapshot of a given object under a RootLevelContainer to the given stream
        static hkBool HK_CALL saveUnderRootLevel( const hkReflect::Var& data, hkStreamWriter* writer,
            Options outputOptions = SNAPSHOT_BINARY_TAGFILE /* Output options are ignored */,
            const char* targetLayout = HK_NULL );

        /// Save a snapshot of a given object to filename.
        static hkBool HK_CALL save( const hkReflect::Var& data, hkStreamWriter* writer,
            Options outputOptions = SNAPSHOT_BINARY_TAGFILE /* Output options are ignored */,
            const char* targetLayout = HK_NULL,
            hkSerialize::Save::VarCallback userCallback = HK_NULL,
            void* userData = HK_NULL);


            /// Load a snapshot from a filename. It will search
            /// the root level container in the file for a hkpPhysicsData class. It will autodetect
            /// the file type (packfile or tagfile).
            /// NOTE: remember to remove the reference from allocatedData once you are finished using the loaded data.
        static class hkpPhysicsData* HK_CALL load(class hkStreamReader* reader, hkResource** allocatedData);
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
