// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Physics2012/Collide/hkpExport.h>
#include <Physics2012/Utilities/Serialize/hkpHavokSnapshot.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/OStream/hkOStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/World/hkpWorld.h>
#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>
#include <Physics2012/Utilities/Serialize/hkpPhysicsData.h>

#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Physics2012/Collide/Shape/Deprecated/StorageMesh/hkpStorageMeshShape.h>
#include <Physics2012/Collide/Shape/Compound/Collection/StorageExtendedMesh/hkpStorageExtendedMeshShape.h>
#include <Physics2012/Collide/Shape/HeightField/StorageSampledHeightField/hkpStorageSampledHeightFieldShape.h>
#include <Physics2012/Collide/Shape/HeightField/TriSampledHeightField/hkpTriSampledHeightFieldCollection.h>

#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Base/Serialize/Format/Xml/hkXmlWriteFormat.h>

hkpPhysicsData* HK_CALL hkpHavokSnapshot::load(hkStreamReader* reader, hkResource** allocatedData)
{
    HK_ASSERT(0x74de3808, reader, "Null hkStreamReader pointer was passed to hkpHavokSnapshot::load");
    HK_ASSERT(0x54c68870, allocatedData, "Null hkResource pointer was passed to hkpHavokSnapshot::load");

    // Fail quickly if null pointers were given
    if ( (!reader) || (!allocatedData) )
    {
        return HK_NULL;
    }

    if( hkResource* resource = hkSerializeUtil::load(reader) )
    {
        if( hkRootLevelContainer* container = resource->getContents<hkRootLevelContainer>() )
        {
            // first search by type
            hkpPhysicsData* data = container->findObject<hkpPhysicsData>();
            if(data == HK_NULL)
            {
                // failing that, by variant name.
                const char* byName[] = { "SnapshotSave", "hkpPhysicsData", HK_NULL };
                for( int i = 0; byName[i] != HK_NULL; ++i )
                {
                    data = static_cast<hkpPhysicsData*>( container->findObjectByName( byName[i] ) );
                    if( data )
                    {
                        break;
                    }
                }
            }
            if(data != HK_NULL)
            {
                *allocatedData = resource;
                return data;
            }
        }
    }

    HK_WARN(0x764219fe, "Could not load a hkRootLevelContainer from given stream.");
    return HK_NULL;
}

static void s_snapshotCallback( const hkReflect::Var& var, hkSerialize::BundleBuilder& bb, void* data)
{
    hkArray< hkRefPtr<hkReferencedObject> >& objects = *static_cast< hkArray< hkRefPtr<hkReferencedObject> >* >(data);
    if( var.getType()->extendsOrEquals<hkpMeshShape>() && !var.getType()->equals<hkpStorageMeshShape>() )
    {
        const hkpMeshShape* mesh = var.dynCast<hkpMeshShape>();
        hkpStorageMeshShape* storage = new hkpStorageMeshShape(mesh);
        objects.pushBack(hkRefNew<hkReferencedObject>(storage));
        bb.addSubstitution(storage, var);
    }
    if( var.getType()->extendsOrEquals<hkpExtendedMeshShape>() && !var.getType()->equals<hkpStorageExtendedMeshShape>() )
    {
        const hkpExtendedMeshShape* mesh = var.dynCast<hkpExtendedMeshShape>();
        hkpStorageExtendedMeshShape* storage = new hkpStorageExtendedMeshShape(mesh);
        objects.pushBack(hkRefNew<hkReferencedObject>(storage));
        bb.addSubstitution(storage, var);
    }
    else if(const hkpRigidBody* body = var.dynCast<hkpRigidBody>() )
    {
        if( hkpWorld* world = body->getWorld() )
        {
            // It's the world rigid body.
            if( world->getFixedRigidBody() == body )
            {
                bb.addEmpty(var);
            }
        }
        if(body->getCollidable()->getShape()->getType() == hkcdShapeType::SAMPLED_HEIGHT_FIELD)
        {
            const hkpSampledHeightFieldShape* sampled =
                static_cast<const hkpSampledHeightFieldShape*>(body->getCollidable()->getShape());
            if(sampled->m_heightfieldType == hkpSampledHeightFieldShape::HEIGHTFIELD_USER)
            {
                // The rigid body collidable points to a sampledHeightFieldShape, we must replace the rigid body
                // (collidable) with a new one with a new shape.
                hkpRigidBody* newBody = body->clone();
                {
                    hkpShape* storage = new hkpStorageSampledHeightFieldShape(sampled);
                    newBody->setShape(storage);
                    storage->removeReference();
                }

                objects.pushBack(hkRefNew<hkReferencedObject>(newBody));
                bb.addSubstitution(newBody, var);
            }
        }
    }
    else if( const hkpTriSampledHeightFieldCollection* collection = var.dynCast<hkpTriSampledHeightFieldCollection>() )
    {
        const hkpSampledHeightFieldShape* sampled = collection->getHeightFieldShape();
        if(sampled->m_heightfieldType == hkpSampledHeightFieldShape::HEIGHTFIELD_USER)
        {
            hkpStorageSampledHeightFieldShape* storage = new hkpStorageSampledHeightFieldShape(sampled);
            hkpTriSampledHeightFieldCollection* newCollection =
                new hkpTriSampledHeightFieldCollection(storage, collection->getRadius());
            storage->removeReference();
            {
                // Copy additional shape configuration.
                newCollection->m_disableWelding = collection->m_disableWelding;
                newCollection->m_userData = collection->m_userData;
                newCollection->setTriangleExtrusion(collection->getTriangleExtrusion());
            }

            objects.pushBack(hkRefNew<hkReferencedObject>(newCollection));
            bb.addSubstitution(newCollection, var);
        }
    }
    else if (!var.getType()->isSerializable())
    {
        bb.addEmpty(var);
    }
}

hkBool HK_CALL hkpHavokSnapshot::save(const hkpWorld* world, hkStreamWriter* writer, Options outputOptions, const char* targetLayout, bool saveContactPoints)
{
    // Note: because hkpPhysicsData adds a ref to all rbs in the world, and removes the ref
    // on destruction, we have to:
    // Mark the world for write
    // Cast away the const of the world, so we can do this
    // Scope the hkPhysics data so that it goes out of scope and removes refs while the world
    // is still marked for write

    HK_ASSERT(0x4bb93313, world, "Null hkpWorld pointer passed to hkpHavokSnapshot::save.");
    HK_ASSERT(0x23ec02e2, writer, "Null hkStreamWriter passed to hkpHavokSnapshot::save.");

    // Fail if any null pointers were given
    if ( (!world) || (!writer) )
    {
        return false;
    }

    hkpWorld* mutableWorld = const_cast<hkpWorld*>(world);
    hkBool ret;
    mutableWorld->markForWrite();
    {
        // Make a data struct to contain the world info.
        hkpPhysicsData data;
        data.populateFromWorld( mutableWorld, saveContactPoints );

        ret = save( &data, writer, outputOptions, targetLayout );
    }
    mutableWorld->unmarkForWrite();

    return ret;
}


hkBool HK_CALL hkpHavokSnapshot::save( const hkpPhysicsData* data, hkStreamWriter* writer, Options outputOptions, const char* targetLayout)
{
    // Add this to our root level container object
    return saveUnderRootLevel(data, writer, outputOptions, targetLayout);
}

hkBool HK_CALL hkpHavokSnapshot::saveUnderRootLevel( const hkReflect::Var& data, hkStreamWriter* writer, Options outputOptions, const char* targetLayout )
{
    //assume data is the raw data, so create a named variant out of it
    hkRootLevelContainer container;
    container.m_namedVariants.expandOne().set(data.getType()->getName(), data);

    return save(&container, writer, outputOptions, targetLayout);
}

hkBool HK_CALL hkpHavokSnapshot::save(
    const hkReflect::Var& data,
    hkStreamWriter* writer,
    Options outputOptions,
    const char* targetLayout,
    hkSerialize::Save::VarCallback userCallback,
    void* userData)
{
    hkArray< hkRefPtr<hkReferencedObject> > objects;
    hkSerialize::Save save;
    if (userCallback)
    {
        save.withCallbacks(userData, userCallback, HK_NULL);
    }
    else
    {
        save.withCallbacks(&objects, &s_snapshotCallback, HK_NULL);
    }

    if (outputOptions.allAreSet(SNAPSHOT_PACKFILE))
    {
        return save.withTarget(targetLayout).contentsVar(data, writer).isSuccess();
    }
    else if (outputOptions.allAreSet(SNAPSHOT_TEXT))
    {
        return save.withFormat<hkSerialize::XmlWriteFormat>().contentsVar(data, writer).isSuccess();
    }
    else
    {
        return save.contentsVar(data, writer).isSuccess();
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
