// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Physics2012/Dynamics/World/hkpPhysicsSystem.h>

// A collection of display bindings
struct HK_EXPORT_PHYSICS_2012 hkpDisplayBindingData : public hkReferencedObject
{
    //+version(1)
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
    HK_DECLARE_REFLECTION();

    // A single 'rigid body <-> display object' binding
    struct RigidBody : public hkReferencedObject
    {
        //+version(2)
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();
        RigidBody() {}

        hkRefPtr<class hkpRigidBody> m_rigidBody;
        hkRefPtr<hkReferencedObject> m_displayObjectPtr; // Actually always a hkxMesh
        hkMatrix4 m_rigidBodyFromDisplayObjectTransform;
    };


    // A physics system and its collection of bindings
    struct PhysicsSystem : public hkReferencedObject
    {
        //+version(1)
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

        hkArray< hkRefPtr<struct RigidBody> > m_bindings;
        hkRefPtr<class hkpPhysicsSystem> m_system;

        /// For serialization we need a ctor that does not call the ctor of the array on load.
        PhysicsSystem() { }
    };

    hkArray< hkRefPtr<struct RigidBody> > m_rigidBodyBindings;
    hkArray< hkRefPtr<struct PhysicsSystem> > m_physicsSystemBindings;

        /// For serialization we need a ctor that does not call the ctor of the arrays on load.
    hkpDisplayBindingData() { }
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
