// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

hkpSerializedDisplayRbTransforms::hkpSerializedDisplayRbTransforms()
{
}

int hkpSerializedDisplayRbTransforms::getNumPairs() const
{
    return m_transforms.getSize();
}

int hkpSerializedDisplayRbTransforms::findBodyIndex(const hkpRigidBody* b) const
{
    int nt = m_transforms.getSize();
    for (int i=0; i < nt; ++i)
    {
        if (m_transforms[i].m_rb == b)
            return i;
    }
    return -1;
}

hkTransform& hkpSerializedDisplayRbTransforms::getTransform(int pi)
{
    HK_ASSERT_NO_MSG(0x3f539833,  (pi>=0) && (pi<m_transforms.getSize()) );
    return m_transforms[pi].m_localToDisplay;
}

hkpRigidBody* hkpSerializedDisplayRbTransforms::getBody(int pi)
{
    HK_ASSERT_NO_MSG(0x2d2e856c,  (pi>=0) && (pi<m_transforms.getSize()) );
    return m_transforms[pi].m_rb;
}

void hkpSerializedDisplayRbTransforms::addPair( hkpRigidBody* m_rb, const hkTransform& t)
{
    DisplayTransformPair* p = m_transforms.expandBy(1);
    p->m_localToDisplay = t;
    p->m_rb = m_rb;

    m_rb->addReference();
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
