// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>

/// This is a handy, simple, serializable that stores a
/// list of rigidbodies and their original display transform.
/// This transform info can be lost when transforms are collapsed
/// in Havok2 tools for optimization of collision detection. This
/// change that happens during the collapse is stored here if desired.
/// Typically used by the hke2xml converter etc.
class HK_EXPORT_PHYSICS_2012 hkpSerializedDisplayRbTransforms : public hkReferencedObject
{
public:

    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_UTILITIES);
    HK_DECLARE_REFLECTION();

    inline hkpSerializedDisplayRbTransforms();

    virtual ~hkpSerializedDisplayRbTransforms()
    {
        int nt = m_transforms.getSize();
        for (int i=0; i < nt; ++i)
        {
            m_transforms[i].m_rb->removeReference();
        }
    }

        /// Get the number of bodies mapped by this class.
    inline int getNumPairs() const;

        /// Returns -1 if not present.
    inline int findBodyIndex(const hkpRigidBody* b) const;

        /// Make sure that pi is with range.
    inline hkTransform& getTransform(int pi);

        /// Make sure that pi is with range.
    inline hkpRigidBody* getBody(int pi);

        /// Will reference count rb
    inline void addPair( hkpRigidBody* rb, const hkTransform& t);

public:

    struct DisplayTransformPair
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES, hkpSerializedDisplayRbTransforms::DisplayTransformPair );
        HK_DECLARE_REFLECTION();

        hkpRigidBody* m_rb;
        hkTransform  m_localToDisplay; // difference between the shifted RigidBody (due to collapse transforms perhaps) to the original (display) transform.
    };

    hkArray<struct DisplayTransformPair> m_transforms;
};

#include <Physics2012/Utilities/Serialize/Display/hkpSerializedDisplayRbTransforms.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
