// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Utilities/Serialize/Display/hkpSerializedDisplayMarker.h>

class HK_EXPORT_PHYSICS_2012 hkpSerializedDisplayMarkerList : public hkReferencedObject
{
public:

    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_UTILITIES);
    HK_DECLARE_REFLECTION();

    inline hkpSerializedDisplayMarkerList();

    inline virtual ~hkpSerializedDisplayMarkerList();

        /// Get the number of markers mapped by this class.
    inline int getNumMarkers() const;

        /// Make sure that pi is with range.
    inline hkpSerializedDisplayMarker* getMarker(int pi) const;

        /// Add a marker to the list
    inline void addMarker( hkpSerializedDisplayMarker* m );

public:

    hkArray<hkpSerializedDisplayMarker*> m_markers; // the transform for this marker.
};

#include <Physics2012/Utilities/Serialize/Display/hkpSerializedDisplayMarkerList.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
