// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpWorld;
class hkpRigidBody;
struct hkGeometry;

/// This utility class provides a set of methods useful for creating an hkGeometry from an existing physics integration
class HK_EXPORT_PHYSICS_2012 hkpGeometryConverter
{
    public:

            /// Creates a geometry from a Havok physics world
        static void HK_CALL createSingleGeometryFromWorld( const hkpWorld& world, hkGeometry& geomOut,
            hkBool useFixedBodiesOnly = true, hkBool getMaterialFromUserData = true);

            /// Creates a geometry from a single rigid body
        static void HK_CALL appendGeometryFromRigidBody( const hkpRigidBody& body, hkGeometry& geomOut,
            hkBool getMaterialFromUserData = true);

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
