// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpWorld;

/// This class attempts to keep the stiffness of the system constant when the time step varies from frame to frame.
///
/// This class seems to work for timesteps between 15 fps and 750 fps.
/// If you fall below the min substep count, the time per substep will change, which will
/// result in a noticeable change to the system stiffness. However, this is better than the alternative
/// where the system can totally fail if you fall bellow 2 substeps.
/// This scheme will result in noticeable jitter. A better scheme that keeps jitter down is to
/// always step at n*timePerSubstep, accumulate requestedTimeStep - n*timePerSubstep and do an
/// extra substep when that accumulated ammount > timePerSubstep. Even more solid would be if
/// you did the same, but with full timesteps rather than substeps.
class HK_EXPORT_PHYSICS_2012 hkpVariableTimestepper
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES, hkpVariableTimestepper );

        /// Constructor.
        hkpVariableTimestepper( hkReal timePerSubstep, hkReal minSubstepCount = 2.0f );

        /// Simulate forward in time.
        int step( hkpWorld* world, hkReal timestep );

        /// Time per substep
        hkReal m_timePerSubstep;

        /// Min number of solver substeps allowable
        hkReal m_minSubstepCount;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
