// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent3/Machine/Nn/hkpAgentNnTrack.h>
#include <Physics2012/Dynamics/Collide/hkpSimpleConstraintContactMgr.h>
#include <Physics2012/Dynamics/World/hkpSimulationIsland.h>

#include <Physics2012/Collide/Agent3/Machine/Nn/hkpAgentNnMachine.h>
#include <Physics2012/Collide/Agent3/Machine/1n/hkpAgent1nTrack.h>
#include <Physics2012/Collide/Agent3/Machine/1n/hkpAgent1nMachine.h>

#include <Physics2012/Collide/Dispatch/hkpCollisionDispatcher.h>

#include <Physics2012/Dynamics/Constraint/Contact/hkpContactPointProperties.h>

#define HK_SERIALIZED_AGENT_NN_ENTRY_VERSION 1


struct hkpSerializedSubTrack1nInfo;

struct HK_EXPORT_PHYSICS_2012 hkpSerializedTrack1nInfo
{
    HK_DECLARE_CLASS(hkpSerializedTrack1nInfo, New, Reflect, Version(1));

    hkpSerializedTrack1nInfo() {}
    ~hkpSerializedTrack1nInfo();

    struct Agent1nSector
    {
        HK_DECLARE_CLASS(Agent1nSector, New, Reflect);
        hkUint32 m_bytesAllocated;
        char m_rawData[512-sizeof(hkUint32)];
        hkpAgent1nSector* cast() { return reinterpret_cast<hkpAgent1nSector*>(this); }
    };
    // sectors for this child track + info on further subtracks of this child track
    hkArray<struct Agent1nSector*> m_sectors;
    hkArray<struct hkpSerializedSubTrack1nInfo*> m_subTracks; // have to use a block, or serialization gives up

    hkBool isEmpty() const { HK_ASSERT(0xad8753dd, m_subTracks.isEmpty() || m_sectors.getSize(), "Subracks must must be empty when there are no sectors."); return m_sectors.isEmpty(); }
};

struct HK_EXPORT_PHYSICS_2012 hkpSerializedSubTrack1nInfo : public hkpSerializedTrack1nInfo
{
    HK_DECLARE_REFLECTION();
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_UTILITIES, hkpSerializedSubTrack1nInfo);

    hkpSerializedSubTrack1nInfo() { m_sectorIndex = -1; }

    // location in parent track
    int m_sectorIndex;
    int m_offsetInSector;
};

struct HK_EXPORT_PHYSICS_2012 hkpSerializedAgentNnEntry : public hkReferencedObject
{
    //+version(1)
    HK_DECLARE_REFLECTION();
    HK_RECORD_ATTR(hk::IncludeInMgd(false));
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_UTILITIES);

    inline hkUint32& endianCheckUint32() { return *static_cast<hkUint32*>( static_cast<void*>(m_endianCheckBuffer) ); }

    hkpSerializedAgentNnEntry() : m_bodyA(HK_NULL), m_bodyB(HK_NULL), m_bodyAId(hkUlong(-1)), m_bodyBId(hkUlong(-1)), m_useEntityIds(false)
    {
        endianCheckUint32() = ENDIAN_CHECK_VALUE;
        m_version = HK_SERIALIZED_AGENT_NN_ENTRY_VERSION;
    }

    void afterReflectNew()
    {
        HK_ASSERT(0xad8755cc, m_version == HK_SERIALIZED_AGENT_NN_ENTRY_VERSION, "You're trying to load an older version of hkpSerializedAgentNnEntry, which may be not compatible with this build.");
    }

    virtual ~hkpSerializedAgentNnEntry()
    {
        if (m_bodyA) { m_bodyA->removeReference(); }
        if (m_bodyB) { m_bodyB->removeReference(); }
    }

    enum SerializedAgentType
    {
        INVALID_AGENT_TYPE,
        BOX_BOX_AGENT3,
        CAPSULE_TRIANGLE_AGENT3,
        PRED_GSK_AGENT3,
        PRED_GSK_CYLINDER_AGENT3,
        CONVEX_LIST_AGENT3,
        LIST_AGENT3,
        BV_TREE_AGENT3,
        COLLECTION_COLLECTION_AGENT3,
        COLLECTION_AGENT3
    };

        // Entities linked by the agent entry
    hkpEntity* m_bodyA;
    hkpEntity* m_bodyB;

        // Custom id's identifying the entities linked by the agent entry.
    hkUlong m_bodyAId;
    hkUlong m_bodyBId;

        // Allows you to use custom id's to identify the entities, rather than hkpEntity pointers.
        // If set, you will need to provide an id-to-hkpEntity function when loading contact points.
    hkBool m_useEntityIds;

    hkEnum<SerializedAgentType, hkInt8> m_agentType;

    struct hkpSimpleContactConstraintAtom m_atom;
    hkArray<hkUint8> m_propertiesStream; // We're using a block, because our serialization doesn't support multiple inheritance !!
    hkArray<class hkContactPoint> m_contactPoints;
    hkArray<hkUint8> m_cpIdMgr;

    enum
    {
        ENDIAN_CHECK_VALUE      = 259,
        SIZEOF_NN_ENTRY_DATA    = 192,  /*largest HK_AGENT3_AGENT_SIZE on all platforms*/
    };
    hkUint8 m_nnEntryData[SIZEOF_NN_ENTRY_DATA]; // used optionally

    struct hkpSerializedTrack1nInfo m_trackInfo;

    hkUint8 m_endianCheckBuffer[4];


    hkUint32 m_version;
};

HK_REFLECT_ENUM(HK_EXPORT_PHYSICS_2012, hkpSerializedAgentNnEntry::SerializedAgentType);

#undef HK_SERIALIZED_AGENT_NN_ENTRY_VERSION

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
