// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

struct hkpAgentEntry;
struct hkpProcessCollisionInput;
struct hkpSerializedAgentNnEntry;
struct hkpSerializedTrack1nInfo;

struct hkpAgentNnMachineTimEntry;
struct HK_EXPORT_PHYSICS_2012 hkpAgentNnMachinePaddedEntry;
struct hkpAgent1nMachineTimEntry;
struct hkpAgent1nMachinePaddedEntry;

class hkpBoxBoxManifold;
struct hkpCapsuleTriangleCache3;
class hkpGskCache;
struct hkpGskManifold;
class hkpContactPointProperties;



class HK_EXPORT_PHYSICS_2012 hkpSaveContactPointsEndianUtil
{
    public:
            // Swap endianness in a collision entry, including all recursive subtracks.
        static void HK_CALL swapEndianTypeInCollisionEntry( const hkpProcessCollisionInput* input, hkpSerializedAgentNnEntry& serializedEntry );
        static void HK_CALL swapEndianTypeInEntry( const hkpProcessCollisionInput* input, hkpAgentEntry* entry, hkpSerializedTrack1nInfo& serializedTrack, hkBool isNnEntry, int& sizeOfThisEntryOut, bool& trackUsedOut);
        static void HK_CALL swapEndianTypeIn1nTrack( const hkpProcessCollisionInput* input, hkpSerializedTrack1nInfo& serializedTrack );


        //
        // Helper functions
        //

            // Base endian swapping func
        static inline void reverseBytes(void* start, int count);

            // Basic types swapping
        static inline void swapEndianType(hkUint16& uint16);
        static inline void swapEndianType(hkUint32& uint32);
        static inline void swapEndianType(hkReal& real);
        static inline void swapEndianType(hkVector4& vec4);

            // Agent entry swapping
        static inline void swapEndianType(hkpAgentNnMachineTimEntry* entry);
        static inline void swapEndianType(hkpAgentNnMachinePaddedEntry* entry);
        static inline void swapEndianType(hkpAgent1nMachineTimEntry* entry);
        static inline void swapEndianType(hkpAgent1nMachinePaddedEntry* entry);

            // Agent data swaping
        static inline void swapEndianType(hkpBoxBoxManifold* manifold);
        static inline void swapEndianType(hkpCapsuleTriangleCache3* cache);
        static inline void swapEndianType(hkpGskCache* cache);
        static inline void swapEndianType(hkpGskManifold* manifold);
        static inline void swapEndianType(hkpContactPointProperties* p);



};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
