// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/World/hkpPhysicsSystem.h>
#include <Physics2012/Utilities/Dynamics/SaveContactPoints/hkpSerializedAgentNnEntry.h>

struct hkpSerializedAgentNnEntry;

/// A class to group collections of objects, which typically are serialized together,
/// and should be added and removed from the world together.
/// Examples are a ragdoll, and a vehicle.
class HK_EXPORT_PHYSICS_2012 hkpPhysicsSystemWithContacts : public hkpPhysicsSystem
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_WORLD);
        HK_DECLARE_REFLECTION();
        HK_RECORD_ATTR(hk::IncludeInMgd(false));

        hkpPhysicsSystemWithContacts() {}

        virtual ~hkpPhysicsSystemWithContacts()
        {
            int numContacts = m_contacts.getSize();
            for (int c = 0; c < numContacts; ++c)
            {
                m_contacts[c]->removeReference();
            }
        }

            /// Return a copy of the system, in which all items
            /// are clones of the originals, sharing as much data
            /// as possible (e.g.: shapes, constraintData, etc)
        virtual hkpPhysicsSystem* clone(hkpPhysicsSystem::CloneConstraintMode cloneMode = CLONE_DEFAULT) const;

            /// Shallow copy a system. Just copies arrays of ptrs.
        void copy(const hkpPhysicsSystemWithContacts& toCopy);

            /// Add an action to the list
        void addContact( hkpSerializedAgentNnEntry* c );

            /// Remove a contact from the list.
            /// It does a quick remove, so will not preserve
            /// the order of the list
        void removeContact( int i );

            /// Get the held contact information
        inline const hkArray<hkpSerializedAgentNnEntry*>& getContacts() const;

            /// Gets non-const version of contact points information.
            /// It is recommended to use add/removeContact() instead, as they handle reference counting for the serialized entries.
        inline hkArray<hkpSerializedAgentNnEntry*>& getContactsRw();

        virtual hkBool hasContacts() { return true; }

    protected:

        /// Note, ALL these arrays contain reference counted instances.
        /// The destructor for the system will decrement the references on all held objects
        /// so it assumes that when you fill out these arrays that you give it a referenced
        /// count incremented object
        hkArray<struct hkpSerializedAgentNnEntry*> m_contacts;
};

#include <Physics2012/Utilities/Dynamics/SaveContactPoints/hkpPhysicsSystemWithContacts.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
