// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


#pragma once

class hkpPhantom;

    /// A utility class for batch moving phantoms
class HK_EXPORT_PHYSICS_2012 hkpPhantomBatchMoveUtil
{
    public:
            /// Takes an array of phantoms and an array of positions to move them to.
            /// This function will update the broadphase once using a batch of AABBs representing the given phantoms.
            /// The phantoms can any combination of hkpShapePhanoms (Simple or Caching) or hkpAabbPhantoms.
            /// This can give a significant performance improvement when compared to setting the phantoms' positions sequentially.
            /// \param extraTolerance For hkpShapePhantoms this parameter defines tolerance additional to the world
            ///     tolerance which will be applied when calculating the shape's AABB.
        static void HK_CALL setPositionBatch( hkArray<hkpPhantom*>& phantoms, const hkArray<hkVector4>& positions, hkReal extraTolerance = 0.0f);

            /// ###ACCESS_CHECKS###( [world,HK_ACCESS_RW] [shapePhantom,HK_ACCESS_RW] );
        static void HK_CALL setPositionBatch( hkpPhantom** phantoms, const hkVector4* positions, int numPhantoms, hkReal extraTolerance = 0.0f);

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
