// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Utilities/Dynamics/Inertia/hkpInertiaTensorComputer.h>

void HK_CALL hkpAccurateInertiaTensorComputer_registerSelf();

// A class to accurately calculate the inertia tensor. The default calculation approximates a convex hull by its Aabb
class HK_EXPORT_PHYSICS_2012 hkpAccurateInertiaTensorComputer: public hkpInertiaTensorComputer
{
    public:
            /// Calculate mass properties of a convex hull specified by its vertices.
            /// The convex hull might by expanded by 'radius' or automatically if the convex hull is not a value.
            /// Returns HK_FAILURE only if no vertices are provided, else always compute a valid mass properties and HK_SUCCESS
        static hkResult HK_CALL computeConvexHullMassProperties(const hkStridedVertices& vertices, hkReal radius, hkMassProperties& result);
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
