// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpRigidBody;

/// An impulse accumulator that allow for multiple applications of forces and/or impulses at different positions.
/// Actual change in velocity only happens when flushImpulses is called.
struct HK_EXPORT_PHYSICS_2012 hkpImpulseAccumulator
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkpImpulseAccumulator);
    /// ctor.
                            hkpImpulseAccumulator(hkpRigidBody* body, hkReal timeStep);

    /// clear accumulated impulses.
    void                    clearImpulses();

    /// apply and flush accumulated impulses.
    void                    flushImpulses();

    /// add a force to the accumulator.
    HK_INLINE   void    addForce(hkVector4Parameter position, hkVector4Parameter force);

    /// add an impulse to the accumulator.
    HK_INLINE   void    addImpulse(hkVector4Parameter position, hkVector4Parameter impulse);


    hkpRigidBody*   m_body;                 ///< Target rigid body.
    hkSimdReal      m_dt;                   ///< Time step used to convert forces to impulses.
    hkVector4       m_com;                  ///< World center of mass of the rigid body.
    hkVector4       m_accLinearImpulses;    ///< Accumulated linear impulse.
    hkVector4       m_accAngularImpulses;   ///< Accumulated angular impulse.
};

#include <Physics2012/Utilities/Dynamics/ImpulseAccumulator/hkpImpulseAccumulator.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
