// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Filter/hkpCollisionFilter.h>
#include <Physics2012/Dynamics/Constraint/hkpConstraintListener.h>

    /// DEPRECATED. This collision filter will be removed in future releases of Havok Physics.
    ///
    /// This filter disables collisions between two rigid bodies if they are connected by a constraint (other than a contact constraint);
    /// otherwise, it forwards to another (optional) filter.
    ///
    /// This filter is also a world constraint listener, and it removes agents immediately
    /// upon addition of constraints. Therefore it is not necessary to call
    /// updateCollisionFilter explicitly. You will need to call updateCollisionFilter explicitly
    /// when removing a constraint and expecting collision detection to be reenabled between linked bodies.
class HK_EXPORT_PHYSICS_2012 hkpConstrainedSystemFilter : public hkpCollisionFilter, public hkpConstraintListener
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

            /// Constructor
        hkpConstrainedSystemFilter (const hkpCollisionFilter* otherFilter = HK_NULL);

            // Destructor
        ~hkpConstrainedSystemFilter()
        {
            if (m_otherFilter)
            {
                m_otherFilter->removeReference();
            }
        }

            // Checks two collidables
        virtual hkBool isCollisionEnabled( const hkpCollidable& a, const hkpCollidable& b ) const;

        virtual hkBool isCollisionEnabled( const hkpCollisionInput& input, const hkpCdBody& a, const hkpCdBody& b, const hkpShapeContainer& bContainer, hkpShapeKey bKey  ) const;

        // hkpShapeCollectionFilter interface forwarding
        virtual hkBool isCollisionEnabled( const hkpCollisionInput& input, const hkpCdBody& collectionBodyA, const hkpCdBody& collectionBodyB, const HK_SHAPE_CONTAINER& containerShapeA, const HK_SHAPE_CONTAINER& containerShapeB, hkpShapeKey keyA, hkpShapeKey keyB ) const;

        virtual hkBool isCollisionEnabled( const hkpShapeRayCastInput& aInput, const hkpShapeContainer& bContainer, hkpShapeKey bKey ) const;

        virtual hkBool isCollisionEnabled( const hkpWorldRayCastInput& a, const hkpCollidable& collidableB ) const;


        //
        // Implementation of the hkpConstraintListener interface
        //

            // Called when a constraint is added to the world.
        virtual void constraintAddedCallback( hkpConstraintInstance* constraint );

            // Called when a constraint is removed from the world.
        virtual void constraintRemovedCallback( hkpConstraintInstance* constraint );

    private:

        const hkpCollisionFilter* m_otherFilter;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
