// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Physics2012/Collide/hkpExport.h>
#include <Physics2012/Utilities/Constraint/Chain/hkpPoweredChainMapperUtil.h>
#include <Physics2012/Utilities/Constraint/Chain/hkpPoweredChainMapper.h>

#include <Physics2012/Dynamics/World/hkpWorld.h>
#include <Physics2012/Dynamics/Constraint/Chain/hkpConstraintChainInstance.h>



void hkpPoweredChainMapperUtil::addToWorld(hkpWorld* world, hkpPoweredChainMapper* mapper)
{
    for (int c = 0; c < mapper->m_chains.getSize(); c++)
    {
        world->addConstraint( mapper->m_chains[c] );
    }

    for (int l = 0; l < mapper->m_links.getSize(); l++)
    {
        hkpConstraintInstance* instance = mapper->m_links[l].m_limitConstraint;
        if (instance)
        {
            world->addConstraint( instance );
        }
    }
}

void hkpPoweredChainMapperUtil::removeFromWorld(hkpWorld* world, hkpPoweredChainMapper* mapper)
{
    for (int c = 0; c < mapper->m_chains.getSize(); c++)
    {
        world->removeConstraint( mapper->m_chains[c] );
    }

    for (int l = 0; l < mapper->m_links.getSize(); l++)
    {
        hkpConstraintInstance* instance = mapper->m_links[l].m_limitConstraint;
        if (instance)
        {
            world->removeConstraint( instance );
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
