// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpBallSocketChainData;
class hkpConstraintChainInstance;
class hkpConstraintInstance;
class hkpConstraintMotor;
class hkpEntity;
class hkpPositionConstraintMotor;

    /// Constraint chain utility functions.
class HK_EXPORT_PHYSICS_2012 hkpConstraintChainUtil
{
public:
        //
        // Chain construction functions
        //

        /// This function builds a constraint chain instance, and a powered chain data.
        /// These are build from the ordered constraints list.
        /// All the constraints are assumed to be powered ragdoll/hinge constraints.
        /// The function triggers an assert otherwise.
    static hkpConstraintChainInstance* HK_CALL buildPoweredChain(hkArray<hkpConstraintInstance*>& constraints, hkBool cloneMotors);

        /// This function builds a constraint chain instance, and a powered chain data.
        /// These are build from the ordered constraints list.
        /// All the constraints are assumed to be powered ragdoll/hinge constraints.
        /// The function triggers an assert otherwise.
    static hkpConstraintChainInstance* HK_CALL buildBallSocketChain(hkArray<hkpConstraintInstance*>& constraints);

        /// This function adds a new constraint to a ball-socket constraint chain.
    static void HK_CALL addConstraintToBallSocketChain( hkpConstraintChainInstance* instance, hkpEntity* entityToAppend, const hkVector4& pivotWs );

        /// This function adds a new constraint to a powered constraint chain.
    static void HK_CALL addConstraintToPoweredChain( hkpConstraintChainInstance* instance, hkpEntity* entityToAppend, const hkVector4& pivotWs, hkpConstraintMotor* motor0, hkpConstraintMotor* motor1, hkpConstraintMotor* motor2  );

        /// This function adds a new constraint to a ball-socket constraint chain.
    static hkResult HK_CALL addConstraintToChain(hkpConstraintInstance* newChildInstance, hkpConstraintChainInstance* chainInstance, hkpBallSocketChainData* chainData);

        //
        // Helper functions
        //

        /// This attempts to find a connection from entityA to entityB along the constraints in the allConstraint list.
        /// Upon success, the function return HK_SUCCESS value and fills the entitiesOut and constraintsOut with ordered lists
        /// of entities and constraints visited on the shortes path.
        /// The function returns HK_FAILURE when no path connects entityA and entityB.
    static hkResult HK_CALL findConstraintLinkBetweenEntities(const hkArray<hkpConstraintInstance*>& allConstraints, hkpEntity* entityA, hkpEntity* entityB, hkArray<hkpEntity*>& entitiesOut, hkArray<hkpConstraintInstance*>& constraintsOut);

        /// This returns a list of hkEntities linked to the specified entity by any of the constraints in the allConstraints list.
        /// The entities found are placed in the entitiesOut array, and the constraintsOut array contains the corresponding constraints, which lead to those entities.
    static void HK_CALL getAdjointEntities(const hkArray<hkpConstraintInstance*>& allConstraints, const hkpEntity* entity, hkArray<hkpEntity*>& entitiesOut, hkArray<hkpConstraintInstance*>& constraintsOut);


};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
