// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Convex/ConvexVertices/hkpConvexVerticesShape.h>

class hkPseudoRandomGenerator;

///This class can be used to create random hkConvexVerticesShapes.
class HK_EXPORT_PHYSICS_2012 hkpShapeGenerator
{
    public:
        enum Flags { NONE, NO_PLANE_EQUATIONS };

        static hkpConvexVerticesShape* HK_CALL createRandomConvexVerticesShape( const hkVector4& minbox,
                                                                                const hkVector4& maxbox,
                                                                                int numvert,
                                                                                hkPseudoRandomGenerator *generator,
                                                                                Flags flags = NONE );

        static hkpConvexVerticesShape* HK_CALL createRandomConvexVerticesShapeWithThinTriangles(    const hkVector4& minbox,
                                                                                                const hkVector4& maxbox,
                                                                                                int numvert,
                                                                                                float minEdgeLen,
                                                                                                hkPseudoRandomGenerator *generator,
                                                                                                Flags flags = NONE );

        enum ShapeType
        {
                RANDOM,
                SPHERE,
                CAPSULE,
                BOX,
                TRIANGLE,
                //THIN_TRIANGLE,
                CONVEX_VERTICES,
                CONVEX_VERTICES_BOX,
                SHAPE_MAX
        };

        static hkpConvexShape* HK_CALL createConvexShape( const hkVector4& extents, ShapeType type, hkPseudoRandomGenerator *generator );

            /// Create a convexVerticesShape which is like a box with the given
            /// halfExtents and convexRadius.
        static hkpConvexVerticesShape* HK_CALL createConvexVerticesBox( const hkVector4& halfExtents, hkReal convexRadius = hkConvexShapeDefaultRadius );

        static const char* HK_CALL getShapeTypeName( ShapeType type );
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
