// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

hkpRigidBody* hkpTriggerVolume::getTriggerBody() const
{
    return m_triggerBody;
}

const hkArrayBase<hkpRigidBody*>& hkpTriggerVolume::getOverlappingBodies() const
{
    return m_overlappingBodies;
}

void hkpTriggerVolume::addEvent( hkpRigidBody* body, Operation m_operation )
{
    EventInfo& event = m_eventQueue.expandOne();
    event.m_body = body;
    event.m_operation = m_operation;
    event.m_sortValue = ( (hkUint64) body->m_uid << 32 ) | (hkUint64) m_sequenceNumber;
    ++m_sequenceNumber;
    body->addReference();
}

void hkpTriggerVolume::abandonEventQueue()
{
    const int numEvents = m_eventQueue.getSize();
    for ( int i = 0; i < numEvents; ++i )
    {
        m_eventQueue[i].m_body->removeReference();
    }
    m_eventQueue.clear();
}

hkpTriggerVolume* hkpTriggerVolume::getTriggerVolume( hkpRigidBody* body )
{
    return static_cast<hkpTriggerVolume*>( body->getProperty( HK_PROPERTY_TRIGGER_VOLUME ).getPtr() );
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
