// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpShape;

/// This utility class uniformly scales physics shapes.
/// Note that this is not meant to be used at runtime, but in the tool chain and preprocess stages.
class HK_EXPORT_PHYSICS_2012 hkpShapeScalingUtility
{
public:
HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkpShapeScalingUtility);
    struct ShapePair
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES, hkpShapeScalingUtility::ShapePair );

        /// Old shape.
        hkpShape* originalShape;

        /// New shape. Null if not new.
        hkpShape* newShape;
    };

    /// This will try to uniformly scale the given shape by the given amount.
    /// If you are doing multiple scale calls and you have shared shapes,
    /// you might want to provide an array to persist between calls
    /// to stop the shapes from being shrunk more than once.
    /// This function is recursive.
    static hkpShape* HK_CALL scaleShapeSimd( hkpShape* shape, hkSimdRealParameter scale, hkArray<ShapePair>* doneShapes = HK_NULL );

    static HK_INLINE hkpShape* HK_CALL scaleShape( hkpShape* shape, hkReal scale, hkArray<ShapePair>* doneShapes = HK_NULL )
    {
        return scaleShapeSimd(shape, hkSimdReal::fromFloat(scale), doneShapes);
    }
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
