// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


class hkpMoppCode;
class hkOArchive;
class hkIArchive;


/// This class implements a very basic streaming of a hkpMoppCode object to and from an
/// Archive (platform independent stream). It may be useful to use these methods as a guideline
/// for implementing your own file format, as the implementations used here read/write only the
/// minimum data required.
/// In particular, only basic corruption "safety" checks are included. It is up to the user to ensure
/// any "streamed" MOPP data files are in sync with the hkpMoppBvTreeShape you assign them to, otherwise
/// collision detection will fail. It may be advisable to "hash" the shape into a checksum, and
/// write this as additional data into the file, to avoid any such conflicts.
/// This code reads/writes only one hkMoppCodes per Archive, but you may wish to concatenate several
/// hkMoppCodes into a single Archive using the methods below as a guideline.
///
/// NOTICE : The serialization framework (hkSerialize library) available in Havok 2.2 and late versions offers a much more
/// integrated way to serialize MOPP code and other data.
class HK_EXPORT_PHYSICS_2012 hkpMoppCodeStreamer
{
    public:
            /// Allocate and fill a hkpMoppCode from an Input Archive.
        static hkpMoppCode* HK_CALL readMoppCodeFromArchive(hkIArchive &inputArchive);

            /// Write a hkpMoppCode to an Output Archive.
        static void HK_CALL writeMoppCodeToArchive(const hkpMoppCode* code, hkOArchive &outputArchive);

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
