// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
// ------------------------------------------------------TKBMS v1.0

#pragma once


class hkxMesh;
class hkMeshShape;

class HK_EXPORT_PHYSICS_2012 hkpCreateShapeUtility : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_COLLIDE);

    // Input structure
    class CreateShapeInput
    {
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_COLLIDE, CreateShapeInput);

        // Default constructor
        CreateShapeInput()
            :   m_vertexTM(hkMatrix4::getIdentity())
            ,   m_szMeshName(HK_NULL)
            ,   m_bestFittingShapes(false)
            ,   m_decomposedWorldT(hkTransform::getIdentity())
            ,   m_extraShapeTransform(hkTransform::getIdentity())
            ,   m_enableAutomaticShapeShrinking(true)
            ,   m_defaultConvexRadius(0.0f)
            ,   m_relShrinkRadius(0.05f)
            ,   m_maxVertexDisplacement(0.03f)
            ,   m_extraRadiusOverride(-1.0f)
            ,   m_minBoxExtent(-1.0f)
        {}

    public:
        hkArray<hkVector4>  m_vertices;             // Array of mesh vertices in object space
        hkMatrix4           m_vertexTM;             // The node / mesh transform matrix
        const char *        m_szMeshName;           // The node / mesh name (for debug messages)
        hkBool              m_bestFittingShapes;    // If true, shapes will be orientated for a best fitting

        hkTransform         m_decomposedWorldT;     // space that the shape was created in once the scale etc was baked out
        hkTransform         m_extraShapeTransform;  // information about the extra transformation required to create the shape

        hkBool              m_enableAutomaticShapeShrinking;    // If true, automatic shape shrinking is applied to a shape. If false, the old style default convex radius will be used.
        hkReal              m_defaultConvexRadius;              // This is an override to the global hard-coded default convex radius value (hkConvexShapeDefaultRadius).
        hkReal              m_relShrinkRadius;
        hkReal              m_maxVertexDisplacement;

        hkReal              m_extraRadiusOverride;  // Convex / extra radius override. -1.0 if not set

        hkReal              m_minBoxExtent; // If > 0, all shapes created will have at least this bounding box extent. This can be used to avoid creating degenerated volumes.
    };

    // Output structure
    struct ShapeInfoOutput
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkpCreateShapeUtility::ShapeInfoOutput);
        class HK_EXPORT_PHYSICS_2012 hkpShape   *   m_shape;                // The shape itself
        bool                m_isConvex;             // Whether the object is convex
        hkTransform         m_decomposedWorldT;     // space that the shape was created in once the scale etc was baked out
        hkTransform         m_extraShapeTransform;  // information about the extra transformation required to create the shape
    };

public:
    static hkResult HK_CALL createBoxShape      (CreateShapeInput& input, ShapeInfoOutput& output);
    static hkResult HK_CALL createSphereShape   (CreateShapeInput& input, ShapeInfoOutput& output);
    static hkResult HK_CALL createCapsuleShape  (CreateShapeInput& input, ShapeInfoOutput& output);
    static hkResult HK_CALL createCylinderShape (CreateShapeInput& input, ShapeInfoOutput& output);

public:
    static hkResult HK_CALL computeOBB  (const hkArray<hkVector4>& vertices, const hkMatrix4& vertexTransform, hkReal minBoxExtent, hkVector4& halfExtentsOut, hkTransform& obbTransformOut);
    static hkResult HK_CALL computeAABB (const hkArray<hkVector4>& vertices, const hkMatrix4& vertexTransform, hkReal minBoxExtent, hkVector4& halfExtentsOut, hkTransform& obbTransformOut);

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
