// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// A collection of helper utilities for setting up the group filter
class HK_EXPORT_PHYSICS_2012 hkpGroupFilterUtil
{
    public:
            /// This utility class helps setting up hkpCollidable::m_collisionFilterInfo for the group filter.
            /// The purpose is to disable collisions between object pairs which are connected by a constraint.
            /// This class only works if all the rigid bodies and constraints
            /// can be organized in a hierarchy and the input constraints are sorted
            /// so that the root bodies come first.
            /// \param groupFilterSystemGroup is a unique identifier for this constraint system you can get by
            ///       calling hkpGroupFilter::getNewSystemGroup(). This system group will by applied to the m_collisionFilterInfo
            ///       of all involved bodies. If the bodies already have a system group assigned to, this function will assert.
        static void HK_CALL disableCollisionsBetweenConstraintBodies( const class hkpConstraintInstance*const* constraints, int numConstraints, int groupFilterSystemGroup );
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
