// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/hkpExport.h>
#include <Physics2012/Collide/Filter/Group/hkpGroupFilter.h>
#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>
#include <Physics2012/Dynamics/Constraint/hkpConstraintInstance.h>
#include <Physics2012/Utilities/Collide/Filter/GroupFilter/hkpGroupFilterUtil.h>

void hkpGroupFilterUtil::disableCollisionsBetweenConstraintBodies( const hkpConstraintInstance*const* constraints, int numConstraints, int groupFilterSystemGroup)
{
    int subSystemId = 0;
    HK_ASSERT( 0xf021d53a, numConstraints < 31, "The groupfilter allows a maximum of 32 subids"  );
    for (int i =0; i < numConstraints; i++ )
    {
        hkpRigidBody* bA = constraints[i]->getRigidBodyA();
        hkpRigidBody* bB = constraints[i]->getRigidBodyB();

        if ( !bA || !bA->getCollidable()->getShape() || !bB || !bB->getCollidable()->getShape())
        {
            HK_WARN( 0xf021ad34, "disableCollisionsBetweenConstraintBodies does not work with the hkpWorld::getFixedRigidBody()");
            continue;
        }
        HK_ASSERT( 0xf021f43e, HK_NULL == bA->getWorld() && HK_NULL == bB->getWorld(), "You cannot call this utility after you added the rigid bodies to the world" );


        int subIdA = hkpGroupFilter::getSubSystemIdFromFilterInfo( bA->getCollidable()->getCollisionFilterInfo() );
        int subIdB = hkpGroupFilter::getSubSystemIdFromFilterInfo( bB->getCollidable()->getCollisionFilterInfo() );

        int ignoreA = hkpGroupFilter::getSubSystemDontCollideWithFromFilterInfo( bA->getCollidable()->getCollisionFilterInfo() );
        int ignoreB = hkpGroupFilter::getSubSystemDontCollideWithFromFilterInfo( bB->getCollidable()->getCollisionFilterInfo() );

        int layerA = hkpGroupFilter::getLayerFromFilterInfo( bA->getCollidable()->getCollisionFilterInfo() );
        int layerB = hkpGroupFilter::getLayerFromFilterInfo( bB->getCollidable()->getCollisionFilterInfo() );

            // assign subsystem ids
        if ( !subIdA ){ subIdA = subSystemId++; }
        if ( !subIdB ){ subIdB = subSystemId++; }

        if ( !ignoreA )
        {
            ignoreA = subIdB;
        }
        else
        {
            HK_ASSERT( 0xf01a2e3f, !ignoreB, "The constraints you passed in do not form a hierarchy or are not sorted by a hierarchy" );
            ignoreB = subIdA;
        }

        bA->setCollisionFilterInfo( hkpGroupFilter::calcFilterInfo( layerA, groupFilterSystemGroup, subIdA, ignoreA ) );
        bB->setCollisionFilterInfo( hkpGroupFilter::calcFilterInfo( layerB, groupFilterSystemGroup, subIdB, ignoreB ) );

    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
